/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.video.vlcjplayer;

import adams.core.CleanUpHandler;
import adams.core.DateFormat;
import adams.core.DateUtils;
import adams.core.Properties;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.visualization.video.vlcjplayer.DirectRenderMediaPlayerPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import uk.co.caprica.vlcj.discovery.NativeDiscovery;
import uk.co.caprica.vlcj.player.MediaPlayer;
import uk.co.caprica.vlcj.player.MediaPlayerEventAdapter;
import uk.co.caprica.vlcj.player.MediaPlayerEventListener;

public class VLCjDirectRenderPanel
extends BasePanel
implements MenuBarProvider,
CleanUpHandler {
    private static final long serialVersionUID = -6333350276893620652L;
    public static final String SESSION_FILE = "VLCjVideoPlayerSession.props";
    public static final String FILENAME = "adams/gui/visualization/video/vlcjplayer/VLCjVideoPlayer.props";
    public static final String EVENT_PLAY = "play";
    public static final String EVENT_PAUSE = "pause";
    public static final String EVENT_STOP = "stop";
    public static final String EVENT_MUTE = "mute";
    protected static final double DEFAULT_RATE = 1.0;
    protected static final double MAX_RATE = 4.0;
    protected static final double MIN_RATE = 0.25;
    protected static final double RATE_STEP = 0.25;
    protected static Properties m_Properties;
    protected JMenuBar m_MenuBar;
    protected JMenu m_MenuFileLoadRecent;
    protected RecentFilesHandler<JMenu> m_RecentFilesHandler;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemFileOpen;
    protected BaseFileChooser m_FileChooser;
    protected JMenuItem m_MenuItemVideoShowHideControls;
    protected JMenuItem m_MenuItemVideoPlay;
    protected JMenuItem m_MenuItemVideoPause;
    protected JMenuItem m_MenuItemVideoStop;
    protected JMenuItem m_MenuItemSetSpeed;
    protected File m_CurrentFile;
    protected DirectRenderMediaPlayerPanel m_MediaPlayerComponent;
    protected Logger m_Logger;
    protected BasePanel m_ControlsPanel;
    protected JSlider m_SliderPosition;
    protected JSpinner m_SpinnerRate;
    protected SpinnerNumberModel m_SpinnerModel;
    protected BaseButton m_ButtonPlay;
    protected BaseButton m_ButtonPause;
    protected BaseButton m_ButtonStop;
    protected BaseButton m_ButtonMute;
    protected TitleGenerator m_TitleGenerator;
    protected boolean m_VideoPaused;
    protected boolean m_VideoLoaded;
    protected boolean m_VLCInstalled;
    protected boolean m_VideoPlaying;
    protected ScheduledExecutorService m_Executor;
    protected ScheduledFuture<?> m_ExecutorHandler;
    protected JLabel m_LabelPlaybackTime;
    protected JLabel m_LabelMediaLength;
    protected long m_PlaybackTime;
    protected long m_MediaLength;
    protected DateFormat m_dateFormatter;
    protected Set<ActionListener> m_PlayListeners;
    protected Set<ActionListener> m_PauseListeners;
    protected Set<ActionListener> m_StopListeners;
    protected Set<ActionListener> m_MuteListeners;

    protected void initialize() {
        super.initialize();
        this.m_Logger = LoggingHelper.getLogger(((Object)((Object)this)).getClass());
        this.m_TitleGenerator = new TitleGenerator("VLCj Video Player", true);
        this.m_PlayListeners = new HashSet<ActionListener>();
        this.m_PauseListeners = new HashSet<ActionListener>();
        this.m_StopListeners = new HashSet<ActionListener>();
        this.m_MuteListeners = new HashSet<ActionListener>();
        this.m_VideoPaused = false;
        this.m_VideoLoaded = false;
        this.m_VideoPlaying = false;
        this.m_dateFormatter = DateUtils.getTimeFormatter();
        this.m_VLCInstalled = new NativeDiscovery().discover();
        if (!this.m_VLCInstalled) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"VLC native libraries not found. Please install VLC:\nhttp://www.videolan.org/vlc/ !");
            return;
        }
        this.m_SpinnerModel = new SpinnerNumberModel(1.0, 0.25, 4.0, 0.25);
    }

    public void initGUI() {
        super.initGUI();
        this.m_MediaPlayerComponent = new DirectRenderMediaPlayerPanel();
        this.add((Component)((Object)this.m_MediaPlayerComponent), "Center");
        this.m_ControlsPanel = new BasePanel((LayoutManager)new FlowLayout());
        this.add((Component)this.m_ControlsPanel, "South");
        this.m_SpinnerRate = new JSpinner(this.m_SpinnerModel);
        this.m_SpinnerRate.addChangeListener(e -> {
            JSpinner source = (JSpinner)e.getSource();
            double rate = (Double)source.getValue();
            this.m_MediaPlayerComponent.setRate((float)rate);
        });
        this.m_ControlsPanel.add((Component)this.m_SpinnerRate);
        this.m_SliderPosition = new JSlider(0, 1000, 0);
        this.m_SliderPosition.addChangeListener(e -> {
            JSlider source = (JSlider)e.getSource();
            if (source.getValueIsAdjusting()) {
                this.m_MediaPlayerComponent.setPosition((float)source.getValue() / 1000.0f);
            }
        });
        this.m_ControlsPanel.add((Component)this.m_SliderPosition);
        this.m_LabelPlaybackTime = new JLabel("00:00:00 /");
        this.m_ControlsPanel.add((Component)this.m_LabelPlaybackTime);
        this.m_LabelMediaLength = new JLabel("00:00:00");
        this.m_ControlsPanel.add((Component)this.m_LabelMediaLength);
        this.m_ButtonPlay = new BaseButton((Icon)GUIHelper.getIcon((String)"run_black.gif"));
        this.m_ButtonPlay.addActionListener(e -> this.play());
        this.m_ControlsPanel.add((Component)this.m_ButtonPlay);
        this.m_ButtonPause = new BaseButton((Icon)GUIHelper.getIcon((String)"pause_black.gif"));
        this.m_ButtonPause.addActionListener(e -> this.pause());
        this.m_ControlsPanel.add((Component)this.m_ButtonPause);
        this.m_ButtonStop = new BaseButton((Icon)GUIHelper.getIcon((String)"stop_black.gif"));
        this.m_ButtonStop.addActionListener(e -> this.stop());
        this.m_ControlsPanel.add((Component)this.m_ButtonStop);
        this.m_ButtonMute = new BaseButton((Icon)GUIHelper.getIcon((String)"mute.png"));
        this.m_ButtonMute.addActionListener(e -> this.toggleMute());
        this.m_ControlsPanel.add((Component)this.m_ButtonMute);
    }

    protected void finishInit() {
        super.finishInit();
        this.m_Executor = Executors.newSingleThreadScheduledExecutor();
        this.m_ExecutorHandler = this.m_Executor.scheduleAtFixedRate(() -> {
            int position = (int)(this.m_MediaPlayerComponent.getPosition() * 1000.0f);
            SwingUtilities.invokeLater(() -> this.m_SliderPosition.setValue(position));
            this.m_PlaybackTime = this.m_MediaPlayerComponent.getTime();
            this.m_MediaLength = this.m_MediaPlayerComponent.getLength();
            this.update();
        }, 0L, 1L, TimeUnit.SECONDS);
        this.m_MediaPlayerComponent.addMediaPlayerEventListener((MediaPlayerEventListener)new MediaPlayerEventAdapter(){

            public void finished(MediaPlayer mediaPlayer) {
                VLCjDirectRenderPanel.this.m_VideoPlaying = false;
                VLCjDirectRenderPanel.this.update();
            }
        });
    }

    public void setPlaybackRate(String rateString) {
        try {
            Float rate = Float.valueOf(Float.parseFloat(rateString));
            if ((double)rate.floatValue() > 4.0) {
                rate = Float.valueOf(4.0f);
            } else if ((double)rate.floatValue() < 0.25) {
                rate = Float.valueOf(0.25f);
            }
            this.m_MediaPlayerComponent.setRate(rate.floatValue());
            this.update();
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to parse: " + rateString + "\n" + LoggingHelper.throwableToString((Throwable)e)));
        }
    }

    public void setTitle(String value) {
        this.m_TitleGenerator.setTitle(value);
        this.update();
    }

    public String getTitle() {
        return this.m_TitleGenerator.getTitle();
    }

    public TitleGenerator getTitleGenerator() {
        return this.m_TitleGenerator;
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(e -> this.update());
            JMenuItem menuitem = new JMenuItem("Open...", GUIHelper.getIcon((String)"open.gif"));
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.addActionListener(e -> this.open());
            menu.add(menuitem);
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, 5, (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    VLCjDirectRenderPanel.this.open((File)e.getItem());
                }
            });
            this.m_MenuFileLoadRecent = submenu;
            menuitem = new JMenuItem("Close", GUIHelper.getIcon((String)"exit.png"));
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.addActionListener(e -> this.close());
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            menu.add(menuitem);
            menu = new JMenu("Video");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(e -> this.update());
            menuitem = new JMenuItem("Play");
            menuitem.addActionListener(e -> this.play());
            menuitem.setMnemonic(80);
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed P"));
            menuitem.setEnabled(false);
            this.m_MenuItemVideoPlay = menuitem;
            menu.add(menuitem);
            menuitem = new JMenuItem("Pause");
            menuitem.addActionListener(e -> this.pause());
            menuitem.setMnemonic(80);
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed P"));
            menuitem.setEnabled(false);
            this.m_MenuItemVideoPause = menuitem;
            menu.add(menuitem);
            menuitem = new JMenuItem("Stop");
            menuitem.addActionListener(e -> this.stop());
            menuitem.setMnemonic(83);
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed S"));
            menuitem.setEnabled(false);
            this.m_MenuItemVideoStop = menuitem;
            menu.add(menuitem);
            menuitem = new JMenuItem("Playback speed...");
            menuitem.addActionListener(e -> this.enterPlaybackSpeed());
            this.m_MenuItemSetSpeed = menuitem;
            menu.add(menuitem);
            menuitem = new JCheckBoxMenuItem("Show Controls");
            menuitem.setSelected(VLCjDirectRenderPanel.getProperties().getBoolean("ShowControls", Boolean.valueOf(true)));
            menuitem.setMnemonic('H');
            menuitem.addActionListener(e -> this.showControls(this.m_MenuItemVideoShowHideControls.isSelected()));
            this.m_MenuItemVideoShowHideControls = menuitem;
            menu.add(menuitem);
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public void pause() {
        if (this.m_VideoLoaded && this.m_VideoPlaying) {
            this.m_MediaPlayerComponent.pause();
            this.m_VideoPaused = !this.m_VideoPaused;
            this.notifyPauseListeners();
            this.update();
        }
    }

    public void play() {
        if (!this.m_VideoLoaded) {
            return;
        }
        if (this.m_VideoPlaying && !this.m_VideoPaused) {
            this.pause();
            return;
        }
        this.m_MediaPlayerComponent.play();
        this.m_VideoPlaying = true;
        this.m_VideoPaused = false;
        this.notifyPlayListeners();
        this.update();
    }

    public void stop() {
        if (!this.m_VideoLoaded) {
            return;
        }
        this.m_MediaPlayerComponent.stop();
        this.m_VideoPlaying = false;
        this.m_VideoPaused = false;
        this.update();
    }

    public void mute() {
        this.m_MediaPlayerComponent.mute();
        this.update();
    }

    public void unmute() {
        this.m_MediaPlayerComponent.unmute();
        this.update();
    }

    public void toggleMute() {
        if (this.isSoundMuted()) {
            this.unmute();
        } else {
            this.mute();
        }
    }

    public void enterPlaybackSpeed() {
        String currentRate = Float.toString(this.m_MediaPlayerComponent.getRate());
        String rateString = GUIHelper.showInputDialog((Component)((Object)this), (String)"Enter Playback Speed", (String)currentRate);
        if (rateString != null) {
            this.setPlaybackRate(rateString);
        }
    }

    protected BaseFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new BaseFileChooser();
        }
        return this.m_FileChooser;
    }

    public boolean open() {
        int retVal = this.getFileChooser().showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return false;
        }
        return this.open(this.getFileChooser().getSelectedFile());
    }

    public boolean open(File file) {
        this.m_CurrentFile = file;
        if (!this.m_VLCInstalled) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"VLC native libraries not found. Please install VLC: http://www.videolan.org/vlc/ !");
            return false;
        }
        this.m_MediaPlayerComponent.open(this.m_CurrentFile.getAbsolutePath());
        if (this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentItem((Object)this.m_CurrentFile);
        }
        this.m_VideoLoaded = true;
        this.update();
        return true;
    }

    protected void close() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
        this.cleanUp();
        this.closeParent();
    }

    public void cleanUp() {
        if (this.m_MediaPlayerComponent != null) {
            this.m_MediaPlayerComponent.release();
            this.m_MediaPlayerComponent = null;
        }
        if (this.m_ExecutorHandler != null) {
            this.m_ExecutorHandler.cancel(true);
            this.m_ExecutorHandler = null;
        }
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
        this.updateControls();
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        Runnable run = () -> {
            String title = this.m_TitleGenerator.generate(this.m_CurrentFile);
            this.setParentTitle(title);
        };
        SwingUtilities.invokeLater(run);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        Runnable run = () -> {
            this.m_MenuItemVideoPlay.setEnabled(this.m_VideoLoaded);
            this.m_MenuItemVideoStop.setEnabled(this.m_VideoPlaying);
            this.m_MenuItemVideoPlay.setEnabled(this.m_VideoLoaded && (!this.m_VideoPlaying || this.m_VideoPaused));
            this.m_MenuItemVideoPause.setEnabled(this.m_VideoPlaying && !this.m_VideoPaused);
        };
        SwingUtilities.invokeLater(run);
    }

    protected void updateControls() {
        if (this.m_ControlsPanel == null || this.m_ButtonStop == null || this.m_ButtonPlay == null || this.m_SliderPosition == null || this.m_MediaPlayerComponent == null) {
            return;
        }
        Runnable run = () -> {
            this.m_ButtonStop.setEnabled(this.m_VideoLoaded && this.m_VideoPlaying);
            this.m_ButtonPlay.setEnabled(this.m_VideoLoaded && (!this.m_VideoPlaying || this.m_VideoPaused));
            this.m_ButtonPause.setEnabled(this.m_VideoPlaying && !this.m_VideoPaused);
            this.m_ButtonMute.setEnabled(this.m_VideoLoaded);
            if (this.isSoundMuted()) {
                this.m_ButtonMute.setIcon((Icon)GUIHelper.getIcon((String)"unmute.png"));
            } else {
                this.m_ButtonMute.setIcon((Icon)GUIHelper.getIcon((String)"mute.png"));
            }
            this.m_SliderPosition.setEnabled(this.m_VideoLoaded && this.m_VLCInstalled);
            if (!this.m_MediaPlayerComponent.isPlaying() && !this.m_VideoPaused) {
                this.m_LabelMediaLength.setText(this.m_dateFormatter.format(new Date(0L)));
                this.m_LabelPlaybackTime.setText(this.m_dateFormatter.format(new Date(0L)) + " /");
            } else {
                this.m_LabelMediaLength.setText(this.m_dateFormatter.format(new Date(this.m_MediaLength)));
                this.m_LabelPlaybackTime.setText(this.m_dateFormatter.format(new Date(this.m_PlaybackTime)) + " /");
            }
            this.m_SpinnerRate.setValue(this.m_MediaPlayerComponent.getRate());
        };
        SwingUtilities.invokeLater(run);
    }

    public void showControls(boolean show) {
        if (this.m_ControlsPanel == null) {
            return;
        }
        this.m_ControlsPanel.setVisible(show);
        this.invalidate();
        this.revalidate();
        this.doLayout();
        this.repaint();
    }

    protected static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Properties.read((String)FILENAME);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public long getTimeStamp() {
        return this.m_MediaPlayerComponent.getTime();
    }

    public void addPlayListener(ActionListener l) {
        this.m_PlayListeners.add(l);
    }

    public void removePlayListener(ActionListener l) {
        this.m_PlayListeners.remove(l);
    }

    protected synchronized void notifyPlayListeners() {
        ActionEvent e = new ActionEvent((Object)this, 1001, EVENT_PLAY);
        for (ActionListener l : this.m_PlayListeners) {
            l.actionPerformed(e);
        }
    }

    public void addPauseListener(ActionListener l) {
        this.m_PauseListeners.add(l);
    }

    public void removePauseListener(ActionListener l) {
        this.m_PauseListeners.remove(l);
    }

    protected synchronized void notifyPauseListeners() {
        ActionEvent e = new ActionEvent((Object)this, 1001, EVENT_PAUSE);
        for (ActionListener l : this.m_StopListeners) {
            l.actionPerformed(e);
        }
    }

    public void addStopListener(ActionListener l) {
        this.m_StopListeners.add(l);
    }

    public void removeStopListener(ActionListener l) {
        this.m_StopListeners.remove(l);
    }

    protected synchronized void notifyStopListeners() {
        ActionEvent e = new ActionEvent((Object)this, 1001, EVENT_STOP);
        for (ActionListener l : this.m_StopListeners) {
            l.actionPerformed(e);
        }
    }

    public void addMuteListener(ActionListener l) {
        this.m_MuteListeners.add(l);
    }

    public void removeMuteListener(ActionListener l) {
        this.m_MuteListeners.remove(l);
    }

    protected synchronized void notifyMuteListeners() {
        ActionEvent e = new ActionEvent((Object)this, 1001, EVENT_MUTE);
        for (ActionListener l : this.m_MuteListeners) {
            l.actionPerformed(e);
        }
    }

    public File getCurrentFile() {
        return this.m_CurrentFile;
    }

    public boolean isVideoPaused() {
        return this.m_VideoPaused;
    }

    public boolean isVideoLoaded() {
        return this.m_VideoLoaded;
    }

    public boolean isVideoPlaying() {
        return this.m_VideoPlaying;
    }

    public boolean isVLCInstalled() {
        return this.m_VLCInstalled;
    }

    public boolean isSoundMuted() {
        return this.m_MediaPlayerComponent != null && this.m_MediaPlayerComponent.isMute();
    }
}

