/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.video.GifSequenceWriter;
import adams.flow.sink.AbstractFileWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Array;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public class AnimatedGifFileWriter
extends AbstractFileWriter
implements TechnicalInformationHandler {
    protected int m_Delay;
    protected boolean m_Loop;

    public String globalInfo() {
        return "Creates an animated GIF from the incoming images, using Elliot Kroo's GifSequenceWriter class.\n\nFor more information see:\n" + this.getTechnicalInformation();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Elliot Kroo");
        result.setValue(TechnicalInformation.Field.URL, "http://elliot.kroo.net/software/java/GifSequenceWriter/GifSequenceWriter.java");
        return result;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("delay", "delay", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("loop", "loop", (Object)false);
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"delay", (Object)this.m_Delay, (String)", delay: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"loop", (boolean)this.m_Loop, (String)"loop", (String)", ");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    public String outputFileTipText() {
        return "The GIF file to create.";
    }

    public void setDelay(int value) {
        this.m_Delay = value;
        this.reset();
    }

    public int getDelay() {
        return this.m_Delay;
    }

    public String delayTipText() {
        return "The amount of milli-seconds between frames.";
    }

    public void setLoop(boolean value) {
        this.m_Loop = value;
        this.reset();
    }

    public boolean getLoop() {
        return this.m_Loop;
    }

    public String loopTipText() {
        return "If enabled, the GIF loops indefinitely.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer[].class, String[].class, File[].class};
    }

    protected BufferedImage getImage(Object obj, int index) throws Exception {
        BufferedImage result = null;
        Object item = Array.get(obj, index);
        if (item instanceof AbstractImageContainer) {
            result = ((AbstractImageContainer)item).toBufferedImage();
        } else if (item instanceof String) {
            result = ImageIO.read(new PlaceholderFile((String)item).getAbsoluteFile());
        } else if (item instanceof File) {
            result = ImageIO.read(((File)item).getAbsoluteFile());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        ImageInputStreamImpl output = null;
        GifSequenceWriter writer = null;
        int num = Array.getLength(this.m_InputToken.getPayload());
        try {
            BufferedImage img = this.getImage(this.m_InputToken.getPayload(), 0);
            output = new FileImageOutputStream(this.m_OutputFile.getAbsoluteFile());
            writer = new GifSequenceWriter((ImageOutputStream)((Object)output), img.getType(), this.m_Delay, this.m_Loop);
            writer.writeToSequence(img);
            for (int i = 1; i < num; ++i) {
                writer.writeToSequence(this.getImage(this.m_InputToken.getPayload(), i));
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to create GIF!", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (output != null) {
                try {
                    output.flush();
                    ((FileImageOutputStream)output).close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }
}

