/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.BufferedImageToBufferedImage;
import adams.data.conversion.BufferedImageToOtherFormatConversion;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import boofcv.io.webcamcapture.UtilWebcamCapture;
import com.github.sarxos.webcam.Webcam;
import java.util.List;

public class WebcamImage
extends AbstractSource {
    private static final long serialVersionUID = -5718059337341470131L;
    protected int m_Width;
    protected int m_Height;
    protected BufferedImageToOtherFormatConversion m_Conversion;
    protected String m_Webcam;
    protected transient Webcam m_Current;

    public String globalInfo() {
        return "Grabs a frame from the specified webcam.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("webcam", "webcam", (Object)"");
        this.m_OptionManager.add("width", "width", (Object)this.getDefaultWidth(), (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)this.getDefaultHeight(), (Number)1, null);
        this.m_OptionManager.add("conversion", "conversion", (Object)new BufferedImageToBufferedImage());
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"webcam", (Object)(this.m_Webcam.isEmpty() ? "-default-" : this.m_Webcam), (String)"webcam: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)", resolution: ");
        result = (String)result + " x ";
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height);
        return result;
    }

    public void setWebcam(String value) {
        this.m_Webcam = value;
        this.reset();
    }

    public String getWebcam() {
        return this.m_Webcam;
    }

    public String webcamTipText() {
        return "The webcam name (leave empty for default one).";
    }

    public int getDefaultWidth() {
        return 640;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the image.";
    }

    public int getDefaultHeight() {
        return 480;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the image.";
    }

    public void setConversion(BufferedImageToOtherFormatConversion value) {
        this.m_Conversion = value;
        this.reset();
    }

    public BufferedImageToOtherFormatConversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion for turning the " + BufferedImageContainer.class.getName() + " into another format if necessary.";
    }

    public Class[] generates() {
        return new Class[]{this.m_Conversion.generates()};
    }

    protected String doExecute() {
        Object result = null;
        if (this.m_Current == null) {
            try {
                if (this.m_Webcam.trim().isEmpty()) {
                    this.m_Current = Webcam.getDefault();
                } else {
                    List webcams = Webcam.getWebcams();
                    for (Webcam webcam : webcams) {
                        if (!webcam.getName().equals(this.m_Webcam)) continue;
                        this.m_Current = webcam;
                        break;
                    }
                    if (this.m_Current == null) {
                        result = "Failed to locate webcam '" + this.m_Webcam + "'!";
                    }
                }
                if (this.m_Current != null) {
                    UtilWebcamCapture.adjustResolution((Webcam)this.m_Current, (int)this.getWidth(), (int)this.getHeight());
                    this.m_Current.open();
                }
            }
            catch (Throwable e) {
                result = this.handleException("Failed to access webcam:", e);
            }
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Current != null;
    }

    public Token output() {
        Token result = null;
        if (this.m_Current != null) {
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage((Object)this.m_Current.getImage());
            if (!(this.m_Conversion instanceof BufferedImageToBufferedImage)) {
                this.m_Conversion.setInput((Object)cont);
                String msg = this.m_Conversion.convert();
                if (msg == null) {
                    result = new Token(this.m_Conversion.getOutput());
                }
                this.m_Conversion.cleanUp();
            } else {
                result = new Token((Object)cont);
            }
        }
        return result;
    }

    public void wrapUp() {
        if (this.m_Current != null) {
            this.m_Current.close();
            this.m_Current = null;
        }
        super.wrapUp();
    }
}

