/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.QuadrilateralLocation;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.event.VariableChangeListener;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.PassThrough;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Hashtable;

public class TransformTrackedObject
extends AbstractTransformer
implements CallableActorUser {
    private static final long serialVersionUID = 3690378527551302472L;
    public static final String BACKUP_CALLABLEACTOR = "callable actor";
    protected Field m_Location;
    protected CallableActorReference m_Transformer;
    protected CallableActorHelper m_Helper;
    protected Actor m_CallableActor;
    protected Compatibility m_Compatibility;

    public String globalInfo() {
        return "Transforms the tracked object, as specified in the report, using the specified callable transformer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("location", "location", (Object)new Field("Tracker.Current", DataType.STRING));
        this.m_OptionManager.add("transformer", "transformer", (Object)new CallableActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
        this.m_Compatibility = null;
    }

    public void setLocation(Field value) {
        this.m_Location = value;
        this.reset();
    }

    public Field getLocation() {
        return this.m_Location;
    }

    public String locationTipText() {
        return "The field to retrieve the current location of the object from.";
    }

    public void setTransformer(CallableActorReference value) {
        this.m_Transformer = value;
        this.reset();
    }

    public CallableActorReference getTransformer() {
        return this.m_Transformer;
    }

    public String transformerTipText() {
        return "The callable transformer to apply to the tracked object (optional).";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"location", (Object)this.m_Location, (String)"location: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"transformer", (Object)this.m_Transformer, (String)", transformer: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    protected Actor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive((Actor)this, this.getTransformer());
    }

    public boolean hasCallableActor() {
        return this.m_CallableActor != null;
    }

    public Actor getCallableActor() {
        return this.m_CallableActor;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CALLABLEACTOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_CallableActor != null) {
            result.put(BACKUP_CALLABLEACTOR, this.m_CallableActor);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_CALLABLEACTOR)) {
            this.m_CallableActor = (Actor)state.get(BACKUP_CALLABLEACTOR);
            state.remove(BACKUP_CALLABLEACTOR);
        }
    }

    protected String setUpCallableActor() {
        String result = null;
        this.m_CallableActor = this.findCallableActor();
        if (this.m_CallableActor != null) {
            if (ActorUtils.isTransformer((Actor)this.m_CallableActor)) {
                Compatibility comp = new Compatibility();
                Class[] accepts = ((InputConsumer)this.m_CallableActor).accepts();
                Class[] generates = ((OutputProducer)this.m_CallableActor).generates();
                Class[] acceptsExp = new Class[]{AbstractImageContainer.class, BufferedImageContainer.class};
                Class[] generatesExp = new Class[]{AbstractImageContainer.class, BufferedImageContainer.class};
                if (!comp.isCompatible(acceptsExp, accepts)) {
                    result = "Callable actor '" + this.m_Transformer + "' does not accept " + Utils.classesToString((Class[])acceptsExp) + ", but " + Utils.classesToString((Class[])accepts) + ".";
                } else if (!comp.isCompatible(generates, generatesExp)) {
                    result = "Callable actor '" + this.m_Transformer + "' does not generate " + Utils.classesToString((Class[])generatesExp) + ", but " + Utils.classesToString((Class[])generates) + ".";
                }
                if (result == null) {
                    HashSet variables = this.findVariables(this.m_CallableActor);
                    this.m_DetectedVariables.addAll(variables);
                    if (this.m_DetectedVariables.size() > 0) {
                        this.getVariables().addVariableChangeListener((VariableChangeListener)this);
                    }
                }
            } else {
                result = "Callable actor '" + this.getTransformer() + "' is not a transformer!";
            }
        } else {
            this.m_CallableActor = new PassThrough();
        }
        return result;
    }

    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("transformer")) == null) {
            result = this.setUpCallableActor();
        }
        return result;
    }

    protected AbstractImageContainer transformTrackedObject(AbstractImageContainer cont, QuadrilateralLocation location) {
        AbstractImageContainer result;
        BufferedImageContainer objCont = new BufferedImageContainer();
        BufferedImage img = cont.toBufferedImage();
        Rectangle objLoc = location.rectangleValue();
        int x = Math.max(0, objLoc.x);
        int y = Math.max(0, objLoc.y);
        int width = objLoc.width - (x - objLoc.x);
        int height = objLoc.height - (y - objLoc.y);
        BufferedImage objImg = img.getSubimage(x, y, width, height);
        objCont.setImage((Object)objImg);
        ((InputConsumer)this.m_CallableActor).input(new Token((Object)objCont));
        String msg = this.m_CallableActor.execute();
        if (msg != null) {
            this.getLogger().warning("Failed to apply transformer: " + msg);
            result = cont;
        } else {
            AbstractImageContainer trans = (AbstractImageContainer)((OutputProducer)this.m_CallableActor).output().getPayload();
            objImg = trans.toBufferedImage();
            Graphics2D g = img.createGraphics();
            g.drawImage((Image)objImg, x, y, null);
            g.dispose();
            result = new BufferedImageContainer();
            result.setImage((Object)img);
            result.setReport(cont.getReport().getClone());
            result.setNotes(cont.getNotes().getClone());
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_CallableActor == null) {
            result = this.setUpCallableActor();
        }
        AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
        QuadrilateralLocation location = null;
        if (cont.getReport().hasValue((AbstractField)this.m_Location)) {
            location = new QuadrilateralLocation(cont.getReport().getStringValue((AbstractField)this.m_Location));
        }
        if (!(this.m_CallableActor instanceof PassThrough) && location != null) {
            cont = this.transformTrackedObject(cont, location);
        }
        this.m_OutputToken = new Token((Object)cont);
        return result;
    }
}

