/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.objecttracker;

import adams.core.QuickInfoHelper;
import adams.core.base.QuadrilateralLocation;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.flow.transformer.objecttracker.AbstractObjectTracker;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSimpleReportBasedObjectTracker
extends AbstractObjectTracker {
    private static final long serialVersionUID = -3358731361747308499L;
    protected Field m_Init;
    protected Field m_Current;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("init", "init", (Object)new Field("Tracker.Init", DataType.STRING));
        this.m_OptionManager.add("current", "current", (Object)new Field("Tracker.Current", DataType.STRING));
    }

    public void setInit(Field value) {
        this.m_Init = value;
        this.reset();
    }

    public Field getInit() {
        return this.m_Init;
    }

    public String initTipText() {
        return "The field with the initial object location.";
    }

    public void setCurrent(Field value) {
        this.m_Current = value;
        this.reset();
    }

    public Field getCurrent() {
        return this.m_Current;
    }

    public String currentTipText() {
        return "The field to store the current location of the object in.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"init", (Object)this.m_Init, (String)"init: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"current", (Object)this.m_Current, (String)", current: ");
        return result;
    }

    @Override
    protected List<QuadrilateralLocation> getInitialLocations(AbstractImageContainer cont) {
        ArrayList<QuadrilateralLocation> result = new ArrayList<QuadrilateralLocation>();
        if (cont.getReport().hasValue((AbstractField)this.m_Init)) {
            QuadrilateralLocation location = new QuadrilateralLocation(cont.getReport().getStringValue((AbstractField)this.m_Init));
            result.add(location);
        } else {
            this.getLogger().severe("Failed to locate initial location: " + this.m_Init);
            result = null;
        }
        return result;
    }

    @Override
    protected List<QuadrilateralLocation> postProcessTrackedObjects(AbstractImageContainer cont, List<QuadrilateralLocation> locations) {
        if (locations.size() > 0) {
            cont.getReport().addField((AbstractField)this.m_Current);
            cont.getReport().setValue((AbstractField)this.m_Current, (Object)locations.get(0).toString());
        }
        return locations;
    }
}

