/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.objecttracker;

import adams.core.base.QuadrilateralLocation;
import adams.data.image.AbstractImageContainer;
import adams.flow.transformer.objecttracker.AbstractObjectTracker;
import adams.flow.transformer.objecttracker.ObjectTracker;
import java.util.ArrayList;
import java.util.List;

public class MultiObjectTracker
extends AbstractObjectTracker {
    private static final long serialVersionUID = -5332153959179226936L;
    protected ObjectTracker[] m_Trackers;

    public String globalInfo() {
        return "Applies all the specified trackers to the image container.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tracker", "trackers", (Object)new ObjectTracker[0]);
    }

    public void setTrackers(ObjectTracker[] value) {
        this.m_Trackers = value;
        this.reset();
    }

    public ObjectTracker[] getTrackers() {
        return this.m_Trackers;
    }

    public String trackersTipText() {
        return "The trackers to use.";
    }

    @Override
    protected List<QuadrilateralLocation> getInitialLocations(AbstractImageContainer cont) {
        ArrayList<QuadrilateralLocation> result = new ArrayList<QuadrilateralLocation>();
        result.add(new QuadrilateralLocation());
        return result;
    }

    @Override
    protected String doInitTracking(AbstractImageContainer cont, List<QuadrilateralLocation> locations) {
        Object result = null;
        for (int i = 0; i < this.m_Trackers.length; ++i) {
            ObjectTracker tracker = this.m_Trackers[i];
            result = tracker.initTracking(cont);
            if (result == null) continue;
            result = "Tracker #" + (i + 1) + ": " + (String)result;
        }
        return result;
    }

    @Override
    protected List<QuadrilateralLocation> doTrackObjects(AbstractImageContainer cont) {
        ArrayList<QuadrilateralLocation> result = new ArrayList<QuadrilateralLocation>();
        for (int i = 0; i < this.m_Trackers.length; ++i) {
            ObjectTracker tracker = this.m_Trackers[i];
            List<QuadrilateralLocation> locations = tracker.trackObjects(cont);
            if (locations == null) continue;
            result.addAll(locations);
        }
        return result;
    }
}

