/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.annotator;

import adams.core.CleanUpHandler;
import adams.core.DateFormat;
import adams.core.Properties;
import adams.core.ShorteningType;
import adams.core.io.PlaceholderFile;
import adams.data.container.DataContainer;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractTrailReader;
import adams.data.io.input.ImageReader;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.data.io.output.ImageWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.trail.Trail;
import adams.gui.action.AbstractBaseAction;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.chooser.TrailFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.TitleGenerator;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.visualization.annotator.AnnotationPanel;
import adams.gui.visualization.annotator.Binding;
import adams.gui.visualization.annotator.EditBindingsDialog;
import adams.gui.visualization.annotator.EventQueue;
import adams.gui.visualization.annotator.ExtractBackgroundDialog;
import adams.gui.visualization.annotator.Ticker;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.video.vlcjplayer.VLCjDirectRenderPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class AnnotatorPanel
extends BasePanel
implements MenuBarProvider,
CleanUpHandler {
    private static final long serialVersionUID = 6965340882268141821L;
    public static final String VIDEO_SESSION_FILE = "AnnotatorVideoSession.props";
    public static final String BINDINGS_SESSION_FILE = "AnnotatorBindingSession.props";
    public static final String ANNOTATION_SESSION_FILE = "AnnotatorAnnotationSession.props";
    public static final String BACKGROUND_SESSION_FILE = "AnnotatorBackgroundSession.props";
    protected List<Binding> m_Bindings;
    protected TitleGenerator m_TitleGenerator;
    protected VLCjDirectRenderPanel m_VideoPlayer;
    protected BasePanel m_BindingPanel;
    protected EditBindingsDialog m_BindingsDialog;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected RecentFilesHandler<JMenu> m_RecentVideosHandler;
    protected JMenu m_MenuFileLoadRecentVideos;
    protected RecentFilesHandler<JMenu> m_RecentAnnotationsHandler;
    protected JMenu m_MenuAnnotationLoadRecentAnnotations;
    protected RecentFilesHandler<JMenu> m_RecentBackgroundHandler;
    protected JMenu m_MenuBackgroundLoadRecentBackground;
    protected JMenuItem m_MenuItemVideoClose;
    protected AbstractBaseAction m_ActionNewBindings;
    protected AbstractBaseAction m_ActionEditBindings;
    protected AbstractBaseAction m_ActionNewAnnotations;
    protected AbstractBaseAction m_ActionOpenAnnotations;
    protected JMenuItem m_MenuItemAnnotationsOpen;
    protected AbstractBaseAction m_ActionSaveAnnotations;
    protected AbstractBaseAction m_ActionExtractBackground;
    protected AbstractBaseAction m_ActionExportAnnotations;
    protected AbstractBaseAction m_ActionSaveBindings;
    protected AbstractBaseAction m_ActionLoadBindings;
    protected DateFormat m_dateFormatter;
    protected SpreadSheetFileChooser m_ExportFileChooser;
    protected BaseFileChooser m_SavePropertiesFileChooser;
    protected BaseFileChooser m_LoadPropertiesFileChooser;
    protected EventQueue m_EventQueue;
    protected RecentFilesHandler<JMenu> m_RecentBindingsHandler;
    protected JMenu m_MenuFileLoadRecentBindings;
    protected Ticker m_Ticker;
    protected TrailFileChooser m_AnnotationsFileChooser;
    protected ExtractBackgroundDialog m_ExtractDialog;
    protected BufferedImage m_BackgroundImage;
    protected AbstractBaseAction m_ActionClearBackground;
    protected AbstractBaseAction m_ActionOpenBackground;
    protected AbstractBaseAction m_ActionSaveBackground;
    protected AbstractBaseAction m_ActionViewBackground;
    protected ImageFileChooser m_BackgroundFileChooser;
    protected JMenuItem m_MenuItemBackgroundExtract;
    protected JMenuItem m_MenuItemBackgroundSaveAs;
    protected JMenuItem m_MenuItemBackgroundView;

    protected void initialize() {
        super.initialize();
        this.m_TitleGenerator = new TitleGenerator("Annotator", true, ShorteningType.START);
        this.m_dateFormatter = new DateFormat("HH:mm:ss");
        this.m_Bindings = new ArrayList<Binding>();
        this.m_ExportFileChooser = new SpreadSheetFileChooser();
        this.m_SavePropertiesFileChooser = new BaseFileChooser();
        this.m_AnnotationsFileChooser = new TrailFileChooser();
        this.m_LoadPropertiesFileChooser = new BaseFileChooser();
        this.m_BackgroundFileChooser = new ImageFileChooser();
        this.m_SavePropertiesFileChooser.setAcceptAllFileFilterUsed(false);
        this.m_SavePropertiesFileChooser.setAutoAppendExtension(true);
        this.m_SavePropertiesFileChooser.addChoosableFileFilter((FileFilter)ExtensionFileFilter.getPropertiesFileFilter());
        this.m_SavePropertiesFileChooser.setDefaultExtension("props");
        this.m_LoadPropertiesFileChooser.setAcceptAllFileFilterUsed(false);
        this.m_LoadPropertiesFileChooser.setAutoAppendExtension(true);
        this.m_LoadPropertiesFileChooser.addChoosableFileFilter((FileFilter)ExtensionFileFilter.getPropertiesFileFilter());
        this.m_LoadPropertiesFileChooser.setDefaultExtension("props");
        this.m_EventQueue = new EventQueue();
        this.initActions();
    }

    protected void initActions() {
        AbstractBaseAction action;
        this.m_ActionNewBindings = action = new AbstractBaseAction("New", "new.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.newBindings();
            }
        };
        this.m_ActionEditBindings = action = new AbstractBaseAction("Edit...", "properties.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.editBindings();
            }
        };
        this.m_ActionExportAnnotations = action = new AbstractBaseAction("Export...", "spreadsheet.png"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.export();
            }
        };
        this.m_ActionSaveBindings = action = new AbstractBaseAction("Save as...", "save.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.saveBindings();
            }
        };
        this.m_ActionLoadBindings = action = new AbstractBaseAction("Open...", "open.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.loadBindings();
            }
        };
        this.m_ActionNewAnnotations = action = new AbstractBaseAction("New", "new.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.m_EventQueue.resetTrail();
            }
        };
        this.m_ActionOpenAnnotations = action = new AbstractBaseAction("Open...", "open.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.openAnnotations();
            }
        };
        this.m_ActionSaveAnnotations = action = new AbstractBaseAction("Save As...", "save.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.saveAnnotations();
            }
        };
        this.m_ActionExtractBackground = action = new AbstractBaseAction("Extract...", "preferences.png"){

            protected void doActionPerformed(ActionEvent e) {
                if (AnnotatorPanel.this.m_ExtractDialog == null) {
                    AnnotatorPanel.this.m_ExtractDialog = AnnotatorPanel.this.getParentDialog() != null ? new ExtractBackgroundDialog(AnnotatorPanel.this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ExtractBackgroundDialog(AnnotatorPanel.this.getParentFrame(), true);
                    AnnotatorPanel.this.m_ExtractDialog.setSize(GUIHelper.getDefaultSmallDialogDimension());
                    AnnotatorPanel.this.m_ExtractDialog.setLocationRelativeTo((Component)((Object)AnnotatorPanel.this));
                }
                AnnotatorPanel.this.m_ExtractDialog.setCurrentFile(new PlaceholderFile(AnnotatorPanel.this.m_VideoPlayer.getCurrentFile()));
                AnnotatorPanel.this.m_ExtractDialog.setVisible(true);
                if (AnnotatorPanel.this.m_ExtractDialog.getOption() == 0) {
                    AnnotatorPanel.this.m_BackgroundImage = AnnotatorPanel.this.m_ExtractDialog.getBackgroundImage();
                    AnnotatorPanel.this.m_EventQueue.setBackgroundImage(AnnotatorPanel.this.m_BackgroundImage);
                }
            }
        };
        this.m_ActionClearBackground = action = new AbstractBaseAction("Clear", "new.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.clearBackground();
            }
        };
        this.m_ActionSaveBackground = action = new AbstractBaseAction("Save As...", "save.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.saveBackground();
            }
        };
        this.m_ActionOpenBackground = action = new AbstractBaseAction("Open...", "open.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.openBackground();
            }
        };
        this.m_ActionViewBackground = action = new AbstractBaseAction("View...", "landscape.gif"){

            protected void doActionPerformed(ActionEvent e) {
                AnnotatorPanel.this.viewBackground();
            }
        };
    }

    protected void viewBackground() {
        if (this.m_BackgroundImage == null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"No background image available!");
            return;
        }
        ApprovalDialog dlg = this.getParentDialog() != null ? ApprovalDialog.getInformationDialog((Dialog)this.getParentDialog()) : ApprovalDialog.getInformationDialog((Frame)this.getParentFrame());
        dlg.setDefaultCloseOperation(2);
        dlg.setTitle("Background");
        ImagePanel panel = new ImagePanel();
        panel.setCurrentImage(this.m_BackgroundImage);
        panel.setScale(-1.0);
        dlg.add((Component)panel, (Object)"Center");
        dlg.setSize(640, 480);
        dlg.setLocationRelativeTo((Component)((Object)this));
        dlg.setVisible(true);
    }

    protected void openBackground() {
        int retVal = this.m_BackgroundFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.openBackground(this.m_BackgroundFileChooser.getSelectedPlaceholderFile());
    }

    protected void openBackground(PlaceholderFile file) {
        ImageReader reader = (ImageReader)this.m_BackgroundFileChooser.getReader();
        AbstractImageContainer container = reader.read(file);
        this.m_BackgroundImage = (BufferedImage)container.getImage();
        this.m_EventQueue.setBackgroundImage(this.m_BackgroundImage);
    }

    protected void saveBackground() {
        int retVal = this.m_BackgroundFileChooser.showSaveDialog((Component)((Object)this));
        BufferedImageContainer container = new BufferedImageContainer();
        container.setImage((Object)this.m_BackgroundImage);
        if (retVal != 0) {
            return;
        }
        PlaceholderFile file = this.m_BackgroundFileChooser.getSelectedPlaceholderFile();
        ImageWriter writer = (ImageWriter)this.m_BackgroundFileChooser.getWriter();
        String error = writer.write(file, (AbstractImageContainer)container);
        if (error == null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write image to '" + file + "'!"));
        }
    }

    protected void clearBackground() {
        this.m_BackgroundImage = null;
        this.m_EventQueue.setBackgroundImage(null);
    }

    protected void initGUI() {
        super.initGUI();
        this.m_VideoPlayer = new VLCjDirectRenderPanel();
        this.m_BindingPanel = new BasePanel((LayoutManager)new FlowLayout());
        this.m_Ticker = new Ticker(this.m_VideoPlayer);
        this.add((Component)((Object)this.m_VideoPlayer), "Center");
        this.add((Component)this.m_BindingPanel, "South");
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("Video");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(e -> this.updateMenu());
            JMenuItem menuitem = new JMenuItem("Open...", ImageManager.getIcon((String)"open.gif"));
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.addActionListener(e -> {
                if (this.m_VideoPlayer.open()) {
                    this.m_EventQueue.resetTrail();
                    if (this.m_RecentVideosHandler != null) {
                        this.m_RecentVideosHandler.addRecentItem((Object)this.m_VideoPlayer.getCurrentFile());
                    }
                    this.revalidate();
                }
            });
            menu.add(menuitem);
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentVideosHandler = new RecentFilesHandler(VIDEO_SESSION_FILE, 5, (Object)submenu);
            this.m_RecentVideosHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    AnnotatorPanel.this.m_VideoPlayer.open((File)e.getItem());
                }
            });
            this.m_MenuFileLoadRecentVideos = submenu;
            menuitem = new JMenuItem("Playback speed...");
            menuitem.addActionListener(e -> this.m_VideoPlayer.enterPlaybackSpeed());
            menu.add(menuitem);
            menuitem = new JMenuItem("Quit", ImageManager.getIcon((String)"exit.png"));
            menuitem.setMnemonic('Q');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.addActionListener(e -> this.close());
            this.m_MenuItemVideoClose = menuitem;
            menu.addSeparator();
            menu.add(menuitem);
            menu = new JMenu("Annotations");
            result.add(menu);
            menu.setMnemonic('A');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem((Action)this.m_ActionNewAnnotations);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionOpenAnnotations);
            menu.add(menuitem);
            this.m_MenuItemAnnotationsOpen = menuitem;
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentAnnotationsHandler = new RecentFilesHandler(ANNOTATION_SESSION_FILE, 5, (Object)submenu);
            this.m_RecentAnnotationsHandler.setAddShortcuts(false);
            this.m_RecentAnnotationsHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    AnnotatorPanel.this.openAnnotations(new PlaceholderFile((File)e.getItem()));
                }
            });
            this.m_MenuAnnotationLoadRecentAnnotations = submenu;
            menuitem = new JMenuItem((Action)this.m_ActionSaveAnnotations);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionExportAnnotations);
            menu.add(menuitem);
            menu = new JMenu("Background");
            menu.setMnemonic('g');
            menu.addChangeListener(e -> this.updateMenu());
            result.add(menu);
            menuitem = new JMenuItem((Action)this.m_ActionClearBackground);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionOpenBackground);
            menu.add(menuitem);
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentBackgroundHandler = new RecentFilesHandler(BACKGROUND_SESSION_FILE, 5, (Object)submenu);
            this.m_RecentBackgroundHandler.setAddShortcuts(false);
            this.m_RecentBackgroundHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    AnnotatorPanel.this.openBackground(new PlaceholderFile((File)e.getItem()));
                }
            });
            this.m_MenuBackgroundLoadRecentBackground = submenu;
            menuitem = new JMenuItem((Action)this.m_ActionSaveBackground);
            menu.add(menuitem);
            this.m_MenuItemBackgroundSaveAs = menuitem;
            menuitem.setEnabled(false);
            menuitem = new JMenuItem((Action)this.m_ActionViewBackground);
            menu.add(menuitem);
            this.m_MenuItemBackgroundView = menuitem;
            menuitem.setEnabled(false);
            menuitem = new JMenuItem((Action)this.m_ActionExtractBackground);
            menu.add(menuitem);
            this.m_MenuItemBackgroundExtract = menuitem;
            menuitem.setEnabled(false);
            menu = new JMenu("Shortcuts");
            result.add(menu);
            menu.setMnemonic('H');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem((Action)this.m_ActionNewBindings);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionLoadBindings);
            menu.add(menuitem);
            submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentBindingsHandler = new RecentFilesHandler(BINDINGS_SESSION_FILE, 5, (Object)submenu);
            this.m_RecentBindingsHandler.setAddShortcuts(false);
            this.m_RecentBindingsHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, File>(){

                public void recentItemAdded(RecentItemEvent<JMenu, File> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, File> e) {
                    AnnotatorPanel.this.loadBindings(((File)e.getItem()).getAbsolutePath());
                }
            });
            this.m_MenuFileLoadRecentBindings = submenu;
            menuitem = new JMenuItem((Action)this.m_ActionEditBindings);
            menu.add(menuitem);
            menuitem = new JMenuItem((Action)this.m_ActionSaveBindings);
            menu.add(menuitem);
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        Runnable run = () -> {
            String title = this.m_TitleGenerator.generate(this.m_VideoPlayer.getCurrentFile());
            this.setParentTitle(title);
        };
        SwingUtilities.invokeLater(run);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        if (this.m_VideoPlayer.isVideoLoaded()) {
            this.m_MenuItemBackgroundExtract.setEnabled(true);
        } else {
            this.m_MenuItemBackgroundExtract.setEnabled(false);
        }
        if (this.m_BackgroundImage != null) {
            this.m_MenuItemBackgroundSaveAs.setEnabled(true);
            this.m_MenuItemBackgroundView.setEnabled(true);
        } else {
            this.m_MenuItemBackgroundSaveAs.setEnabled(false);
            this.m_MenuItemBackgroundView.setEnabled(false);
        }
    }

    public void cleanUp() {
        if (this.m_BindingsDialog != null) {
            this.m_BindingsDialog.dispose();
            this.m_BindingsDialog = null;
        }
        if (this.m_VideoPlayer != null) {
            this.m_VideoPlayer.cleanUp();
            this.m_VideoPlayer = null;
        }
        if (this.m_EventQueue != null) {
            this.m_EventQueue.cleanUp();
            this.m_EventQueue = null;
        }
        if (this.m_ExtractDialog != null) {
            this.m_ExtractDialog.dispose();
            this.m_ExtractDialog = null;
        }
    }

    protected void updateBindingBar() {
        Runnable run = () -> {
            this.resetBindingBar();
            for (Binding item : this.m_Bindings) {
                AnnotationPanel panel = new AnnotationPanel();
                panel.configureAnnotationPanel(item, this.m_VideoPlayer);
                this.m_BindingPanel.add((Component)((Object)panel));
                this.m_BindingPanel.revalidate();
                if (this.m_EventQueue != null) {
                    panel.addListener(this.m_EventQueue);
                }
                if (this.m_Ticker == null || !item.isToggleable()) continue;
                this.m_Ticker.addListener(panel);
            }
            this.invalidate();
            this.revalidate();
        };
        SwingUtilities.invokeLater(run);
    }

    protected void resetBindingBar() {
        this.m_BindingPanel.removeAll();
        this.m_Ticker.removeAll();
    }

    public void setTitle(String value) {
        this.m_TitleGenerator.setTitle(value);
    }

    protected void close() {
        if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
        } else if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
        }
        this.cleanUp();
        this.closeParent();
    }

    public void newBindings() {
        this.m_Bindings = new ArrayList<Binding>();
        this.updateBindingBar();
    }

    public void editBindings() {
        this.m_BindingsDialog = this.getParentDialog() != null ? new EditBindingsDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new EditBindingsDialog(this.getParentFrame(), true);
        this.m_BindingsDialog.setBindings(this.m_Bindings);
        this.m_BindingsDialog.setLocationRelativeTo((Component)((Object)this));
        this.m_BindingsDialog.setVisible(true);
        if (this.m_BindingsDialog.getOption() == 2) {
            return;
        }
        this.m_Bindings = this.m_BindingsDialog.getBindings();
        this.updateBindingBar();
    }

    public void export() {
        if (this.m_EventQueue == null) {
            return;
        }
        int retVal = this.m_ExportFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        SpreadSheet sheet = this.m_EventQueue.toSpreadSheet();
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_ExportFileChooser.getWriter();
        if (!writer.write(sheet, this.m_ExportFileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to export data to: " + this.m_ExportFileChooser.getSelectedFile()));
        }
    }

    public void loadBindings() {
        int retVal = this.m_LoadPropertiesFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        String bindingPath = this.m_LoadPropertiesFileChooser.getSelectedFile().getAbsolutePath();
        this.loadBindings(bindingPath);
    }

    protected void saveAnnotations() {
        int retVal = this.m_AnnotationsFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        PlaceholderFile file = this.m_AnnotationsFileChooser.getSelectedPlaceholderFile();
        Trail trail = this.m_EventQueue.getTrail();
        AbstractDataContainerWriter writer = (AbstractDataContainerWriter)this.m_AnnotationsFileChooser.getWriter();
        writer.setOutput(file);
        if (!writer.write((DataContainer)trail)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write trail to '" + file + "'!\nCheck console for error message."));
        }
    }

    protected void openAnnotations() {
        int retVal = this.m_AnnotationsFileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        this.openAnnotations(this.m_AnnotationsFileChooser.getSelectedPlaceholderFile());
    }

    protected void openAnnotations(PlaceholderFile file) {
        AbstractTrailReader reader = (AbstractTrailReader)((Object)this.m_AnnotationsFileChooser.getReader());
        reader.setInput(file);
        List readTrail = reader.read();
        if (readTrail.size() == 0) {
            return;
        }
        this.m_EventQueue.loadTrail((Trail)((Object)readTrail.get(0)));
        this.m_RecentAnnotationsHandler.addRecentItem((Object)file);
    }

    public void loadBindings(String bindingPath) {
        Properties props = new Properties();
        props.load(bindingPath);
        this.m_Bindings = new ArrayList<Binding>();
        int count = props.getInteger("Count");
        for (int i = 0; i < count; ++i) {
            try {
                String prefix = Integer.toString(i);
                Properties subset = props.subset(prefix);
                Binding b = new Binding(subset, prefix);
                this.m_Bindings.add(b);
                continue;
            }
            catch (InvalidKeyException e) {
                System.err.println(e.getMessage());
            }
        }
        this.updateBindingBar();
        if (this.m_RecentBindingsHandler != null) {
            this.m_RecentBindingsHandler.addRecentItem((Object)new File(bindingPath));
        }
    }

    public void saveBindings() {
        int i;
        Properties props = new Properties();
        int retVal = this.m_SavePropertiesFileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (i = 0; i < this.m_Bindings.size(); ++i) {
            props.add(this.m_Bindings.get(i).toProperty(i));
        }
        props.setInteger("Count", Integer.valueOf(i));
        String savePath = this.m_SavePropertiesFileChooser.getSelectedFile().getAbsolutePath();
        props.save(savePath);
        if (this.m_RecentBindingsHandler != null) {
            this.m_RecentBindingsHandler.addRecentItem((Object)new File(savePath));
        }
    }
}

