/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.BoxPlot;
import adams.flow.source.SingleFileSupplier;
import adams.flow.transformer.WekaClassSelector;
import adams.flow.transformer.WekaFileReader;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class BoxPlotTest
extends AbstractFlowTest {
    public BoxPlotTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("waveform-5000.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("waveform-5000.arff");
        super.tearDown();
    }

    public AbstractActor getActor() {
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("waveform-5000.arff"));
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        WekaClassSelector cs = new WekaClassSelector();
        BoxPlot bp = new BoxPlot();
        bp.setNumHorizontal(10);
        bp.setHeightPlot(150);
        bp.setSameAxis(true);
        bp.setAttributes("1-40");
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{sfs, fr, cs, bp});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(BoxPlotTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BoxPlotTest.runTest((Test)BoxPlotTest.suite());
    }
}

