/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spc;

import adams.core.TechnicalInformation;
import adams.data.spc.AbstractControlChartWithSampleSize;
import adams.data.spc.Limits;
import adams.data.spc.SamplesControlChart;
import adams.data.statistics.SPCUtils;
import java.util.ArrayList;
import java.util.List;

public class XBarRChart
extends AbstractControlChartWithSampleSize
implements SamplesControlChart {
    private static final long serialVersionUID = 4352909660548550374L;
    protected boolean m_Variation;

    public String globalInfo() {
        return "Generates data for a XBar R chart.\n\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("variation", "variation", (Object)false);
    }

    @Override
    protected int getDefaultSampleSize() {
        return -1;
    }

    @Override
    protected Number getDefaultSampleSizeLowerLimit() {
        return -1;
    }

    @Override
    public String sampleSizeTipText() {
        return "The sample size to use; use < 0 to automatically determine from data.";
    }

    public void setVariation(boolean value) {
        this.m_Variation = value;
        this.reset();
    }

    public boolean getVariation() {
        return this.m_Variation;
    }

    public String variationTipText() {
        return "If enabled, variation data instead of mean data is generated.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "QICacros");
        result.setValue(TechnicalInformation.Field.TITLE, "X bar R Chart Formulas");
        result.setValue(TechnicalInformation.Field.URL, "http://www.qimacros.com/control-chart-formulas/x-bar-r-chart-formula/");
        return result;
    }

    @Override
    public String getName() {
        return "Xbar R chart (" + (this.m_Variation ? "variation" : "mean") + ")";
    }

    protected int getActualSampleSize(Number[][] data) {
        if (this.m_SampleSize > 0) {
            return this.m_SampleSize;
        }
        return data[0].length;
    }

    @Override
    public List<Limits> calculate(Number[][] data) {
        ArrayList<Limits> result = new ArrayList<Limits>();
        if (this.m_Variation) {
            result.add(new Limits(SPCUtils.stats_x_bar_r_r((Number[][])data, (int)this.getActualSampleSize(data))));
        } else {
            result.add(new Limits(SPCUtils.stats_x_bar_r_x((Number[][])data, (int)this.getActualSampleSize(data))));
        }
        return result;
    }

    @Override
    public double[] prepare(Number[][] data) {
        if (this.m_Variation) {
            return SPCUtils.prepare_data_x_bar_r_r((Number[][])data, (int)this.getActualSampleSize(data));
        }
        return SPCUtils.prepare_data_x_bar_rs_x((Number[][])data, (int)this.getActualSampleSize(data));
    }
}

