/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.Conversion;
import adams.data.conversion.SpreadSheetToDoubleMatrix;
import adams.data.conversion.StringToDouble;
import adams.data.spc.CChart;
import adams.data.spc.IndividualsControlChart;
import adams.data.spc.MatrixControlChart;
import adams.data.spc.NullViolations;
import adams.data.spc.SamplesControlChart;
import adams.data.spc.ViolationFinder;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.ControlChartPlot;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SpreadSheetInfo;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;

public class ControlChart
extends AbstractChartGenerator {
    private static final long serialVersionUID = -2495314289911915476L;
    protected adams.data.spc.ControlChart m_Chart;
    protected ViolationFinder m_ViolationFinder;
    protected SpreadSheetColumnRange m_Columns;

    public String globalInfo() {
        return "Generates the specified control chart from the data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)"");
        this.m_OptionManager.add("chart", "chart", (Object)new CChart());
        this.m_OptionManager.add("violation-finder", "violationFinder", (Object)new NullViolations());
    }

    protected void initialize() {
        super.initialize();
        this.m_Columns = new SpreadSheetColumnRange();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"chart", (Object)this.m_Chart, (String)"chart: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"violationFinder", (Object)this.m_ViolationFinder, (String)", violations: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)(this.m_Columns.isEmpty() ? "-none-" : this.m_Columns), (String)", col: ");
        return result;
    }

    public void setChart(adams.data.spc.ControlChart value) {
        this.m_Chart = value;
        this.reset();
    }

    public adams.data.spc.ControlChart getChart() {
        return this.m_Chart;
    }

    public String chartTipText() {
        return "The control chart to generate.";
    }

    public void setViolationFinder(ViolationFinder value) {
        this.m_ViolationFinder = value;
        this.reset();
    }

    public ViolationFinder getViolationFinder() {
        return this.m_ViolationFinder;
    }

    public String violationFinderTipText() {
        return "The algorithm for locating violations.";
    }

    public void setColumns(String value) {
        this.m_Columns.setRange(value);
        this.reset();
    }

    public String getColumns() {
        return this.m_Columns.getRange();
    }

    public String columnsTipText() {
        return "The columns to generate the control chart(s) for; " + this.m_Columns.getExample();
    }

    protected void check(String name, SpreadSheet sheet) {
        super.check(name, sheet);
        this.m_Columns.setData((Object)sheet);
        int[] indices = this.m_Columns.getIntIndices();
        if (this.getColumns().trim().isEmpty() || indices.length == 0) {
            if (this.m_Chart instanceof IndividualsControlChart) {
                throw new IllegalStateException("No column selected!");
            }
            throw new IllegalStateException("No columns selected!");
        }
        if (this.m_Chart instanceof IndividualsControlChart && indices.length != 1) {
            throw new IllegalStateException("Expected 1 column, but " + indices.length + " selected!");
        }
        if (this.m_Chart instanceof SamplesControlChart && indices.length != 2) {
            throw new IllegalStateException("Expected 2 columns, but " + indices.length + " selected!");
        }
        if (this.m_Chart instanceof MatrixControlChart && indices.length < 2) {
            throw new IllegalStateException("Expected at least 2 columns, but " + indices.length + " selected!");
        }
    }

    protected void addChartGeneration(Flow flow, String name, SpreadSheet sheet) {
        if (this.m_Chart instanceof IndividualsControlChart) {
            SpreadSheetInfo info = new SpreadSheetInfo();
            info.setColumnIndex(new SpreadSheetColumnIndex(this.getColumns()));
            info.setType(SpreadSheetInfo.InfoType.CELL_VALUES);
            info.setOutputArray(true);
            flow.add((AbstractActor)info);
            ArrayProcess proc = new ArrayProcess();
            flow.add((AbstractActor)proc);
            StringToDouble todouble = new StringToDouble();
            Convert conv = new Convert();
            conv.setConversion((Conversion)todouble);
            proc.add((AbstractActor)conv);
        } else {
            SpreadSheetToDoubleMatrix matrix = new SpreadSheetToDoubleMatrix();
            matrix.setColumns(new SpreadSheetColumnRange(this.getColumns()));
            Convert conv = new Convert();
            conv.setConversion((Conversion)matrix);
            flow.add((AbstractActor)conv);
        }
        adams.flow.transformer.ControlChart chart = new adams.flow.transformer.ControlChart();
        chart.setChart(this.m_Chart);
        flow.add((AbstractActor)chart);
        ControlChartPlot plot = new ControlChartPlot();
        plot.setViolationFinder(this.m_ViolationFinder);
        if (name != null) {
            plot.setTitle(name + " - " + this.m_Chart.getName());
        } else {
            plot.setTitle("Control chart - " + this.m_Chart.getName());
        }
        plot.setName(plot.getTitle());
        plot.setShortTitle(true);
        flow.add((AbstractActor)plot);
    }
}

