/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spc.IndividualsControlChart;
import adams.data.spc.Limits;
import adams.data.spc.MatrixControlChart;
import adams.data.spc.UChart;
import adams.data.statistics.StatUtils;
import adams.flow.container.ControlChartContainer;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.List;

public class ControlChart
extends AbstractArrayProvider {
    private static final long serialVersionUID = 4013915680601748582L;
    protected adams.data.spc.ControlChart m_Chart;

    public String globalInfo() {
        return "Applies a control chart algorithm to the data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("chart", "chart", (Object)new UChart());
    }

    protected Class getItemClass() {
        return ControlChartContainer.class;
    }

    public String outputArrayTipText() {
        return "Whether to output the control chart containers as array or one-by-one.";
    }

    public void setChart(adams.data.spc.ControlChart value) {
        this.m_Chart = value;
        this.reset();
    }

    public adams.data.spc.ControlChart getChart() {
        return this.m_Chart;
    }

    public String chartTipText() {
        return "The control chart algorithm to use.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"chart", (Object)this.m_Chart);
    }

    public Class[] accepts() {
        if (this.m_Chart == null) {
            return new Class[]{Unknown.class};
        }
        if (this.m_Chart instanceof IndividualsControlChart) {
            return new Class[]{Double[].class, double[].class, Float[].class, float[].class, Integer[].class, int[].class};
        }
        if (this.m_Chart instanceof MatrixControlChart) {
            return new Class[]{Double[][].class, double[][].class, Float[][].class, float[][].class, Integer[][].class, int[][].class};
        }
        throw new IllegalStateException("Unhandled control chart type: " + this.m_Chart.getClass().getName());
    }

    protected String doExecute() {
        String result;
        block28: {
            result = null;
            this.m_Queue.clear();
            try {
                Object data = this.m_InputToken.getPayload();
                if (this.m_Chart instanceof IndividualsControlChart) {
                    Number[] numberArray;
                    if (data instanceof Double[]) {
                        numberArray = (Double[])data;
                    } else if (data instanceof double[]) {
                        numberArray = StatUtils.toNumberArray((double[])((double[])data));
                    } else if (data instanceof Float[]) {
                        numberArray = (Float[])data;
                    } else if (data instanceof float[]) {
                        numberArray = StatUtils.toNumberArray((float[])((float[])data));
                    } else if (data instanceof Integer[]) {
                        numberArray = (Integer[])data;
                    } else if (data instanceof int[]) {
                        numberArray = StatUtils.toNumberArray((int[])((int[])data));
                    } else {
                        throw new IllegalStateException("Unhandled data type: " + Utils.classToString(data.getClass()));
                    }
                    List<Limits> stats = ((IndividualsControlChart)this.m_Chart).calculate(numberArray);
                    double[] prepared = ((IndividualsControlChart)this.m_Chart).prepare(numberArray);
                    ControlChartContainer cont = new ControlChartContainer(this.m_Chart, null, data, prepared, stats.toArray(new Limits[stats.size()]));
                    this.m_Queue.add(cont);
                    break block28;
                }
                if (this.m_Chart instanceof MatrixControlChart) {
                    Number[][] numberMatrix;
                    if (data instanceof Double[][]) {
                        numberMatrix = (Double[][])data;
                    } else if (data instanceof double[][]) {
                        numberMatrix = StatUtils.toNumberMatrix((double[][])((double[][])data));
                    } else if (data instanceof Float[][]) {
                        numberMatrix = (Float[][])data;
                    } else if (data instanceof float[][]) {
                        numberMatrix = StatUtils.toNumberMatrix((float[][])((float[][])data));
                    } else if (data instanceof Integer[][]) {
                        numberMatrix = (Integer[][])data;
                    } else if (data instanceof int[][]) {
                        numberMatrix = StatUtils.toNumberMatrix((int[][])((int[][])data));
                    } else {
                        throw new IllegalStateException("Unhandled data type: " + Utils.classToString(data.getClass()));
                    }
                    List<Limits> stats = ((MatrixControlChart)this.m_Chart).calculate(numberMatrix);
                    double[] prepared = ((MatrixControlChart)this.m_Chart).prepare(numberMatrix);
                    ControlChartContainer cont = new ControlChartContainer(this.m_Chart, null, data, prepared, stats.toArray(new Limits[stats.size()]));
                    this.m_Queue.add(cont);
                    break block28;
                }
                throw new IllegalStateException("Unhandled control chart type: " + this.m_Chart.getClass().getName());
            }
            catch (Exception e) {
                this.m_OutputToken = null;
                result = this.handleException("Failed to generate control chart data: " + this.m_InputToken.getPayload(), e);
            }
        }
        return result;
    }
}

