/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.boxplot;

import adams.core.Range;
import adams.data.statistics.StatUtils;
import adams.gui.core.BaseListWithButtons;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ParameterPanel;
import adams.gui.event.PaintEvent;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.boxplot.BoxPlotGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.core.Attribute;
import weka.core.Instances;

public class BoxPlotManager
extends BasePanel
implements PaintListener {
    private static final long serialVersionUID = -7912792208597490973L;
    protected DefaultListModel m_Attributes;
    protected DefaultListModel m_Chosen;
    protected JPanel m_Centre;
    protected Instances m_Instances;
    protected int m_WidthLeft;
    protected int m_Width;
    protected int m_Height;
    protected int m_AxisWidth;
    protected int m_NumHorizontal;
    protected boolean m_AxisSame;
    protected Color m_Color;
    protected boolean m_Fill;
    protected JSpinner m_WidthSpin;
    protected JSpinner m_HeightSpin;
    protected JSpinner m_AxisWidSpin;
    protected JCheckBox m_SameAxis;
    protected Range m_Range;
    protected JButton m_Add;
    protected JButton m_AddAll;
    protected BaseListWithButtons m_AttributesDis;
    protected BaseListWithButtons m_ChosenDis;
    protected JButton m_Remove;
    protected JButton m_RemoveAll;
    protected ParameterPanel m_PanelParams;
    protected JSpinner m_GridSpin;
    protected JCheckBox m_FillCheck;
    protected JButton m_Colorbutton;

    protected void initialize() {
        super.initialize();
        this.m_Width = 200;
        this.m_Height = 200;
        this.m_AxisWidth = 60;
        this.m_NumHorizontal = -1;
    }

    public BoxPlotManager() {
        super((LayoutManager)new BorderLayout());
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_Add.setEnabled(this.m_AttributesDis.getSelectedIndex() != -1);
        this.m_AddAll.setEnabled(this.m_Attributes.size() != 0);
        this.m_Remove.setEnabled(this.m_ChosenDis.getSelectedIndex() != -1);
        this.m_RemoveAll.setEnabled(this.m_Chosen.size() != 0);
    }

    protected void initGUI() {
        BaseSplitPane splitPane = new BaseSplitPane(1);
        this.m_Centre = new JPanel(new BorderLayout());
        splitPane.setRightComponent((Component)this.m_Centre);
        this.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.3);
        splitPane.setOneTouchExpandable(true);
        this.m_Attributes = new DefaultListModel();
        this.m_Chosen = new DefaultListModel();
        JPanel west = new JPanel(new BorderLayout());
        west.setPreferredSize(new Dimension(this.m_WidthLeft, 1000));
        JPanel top = new JPanel(new BorderLayout());
        this.m_AttributesDis = new BaseListWithButtons();
        this.m_AttributesDis.setPreferredSize(new Dimension(this.m_WidthLeft, 140));
        this.m_AttributesDis.setModel((ListModel)this.m_Attributes);
        top.add((Component)this.m_AttributesDis, "North");
        this.m_Add = new JButton("Add");
        this.m_Add.setMnemonic('A');
        this.m_Add.setEnabled(false);
        this.m_Add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxPlotManager.this.addClicked();
            }
        });
        this.m_AddAll = new JButton("Add all");
        this.m_AddAll.setMnemonic('d');
        this.m_AddAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxPlotManager.this.addAllClicked();
            }
        });
        this.m_AttributesDis.setBorder((Border)BorderFactory.createTitledBorder("Attributes"));
        this.m_AttributesDis.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BoxPlotManager.this.updateButtons();
            }
        });
        this.m_Add.setPreferredSize(new Dimension(110, 30));
        this.m_AddAll.setPreferredSize(new Dimension(110, 30));
        this.m_AttributesDis.addToButtonsPanel((Component)this.m_Add);
        this.m_AttributesDis.addToButtonsPanel((Component)this.m_AddAll);
        JPanel bottom = new JPanel(new BorderLayout());
        this.m_ChosenDis = new BaseListWithButtons();
        this.m_ChosenDis.setPreferredSize(new Dimension(this.m_WidthLeft, 140));
        this.m_ChosenDis.setModel((ListModel)this.m_Chosen);
        bottom.add((Component)this.m_ChosenDis, "Center");
        this.m_Remove = new JButton("Remove");
        this.m_Remove.setMnemonic('R');
        this.m_Remove.setEnabled(false);
        this.m_Remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxPlotManager.this.removeClicked();
            }
        });
        this.m_RemoveAll = new JButton("Remove all");
        this.m_RemoveAll.setMnemonic('m');
        this.m_RemoveAll.setEnabled(false);
        this.m_RemoveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BoxPlotManager.this.removeAllClicked();
            }
        });
        this.m_ChosenDis.setBorder((Border)BorderFactory.createTitledBorder("Chosen attributes"));
        this.m_ChosenDis.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BoxPlotManager.this.updateButtons();
            }
        });
        this.m_Remove.setPreferredSize(new Dimension(110, 30));
        this.m_RemoveAll.setPreferredSize(new Dimension(110, 30));
        this.m_ChosenDis.addToButtonsPanel((Component)this.m_RemoveAll);
        this.m_ChosenDis.addToButtonsPanel((Component)this.m_Remove);
        this.m_PanelParams = new ParameterPanel();
        JPanel centre = new JPanel(new BorderLayout());
        centre.setPreferredSize(new Dimension(this.m_WidthLeft, 350));
        SpinnerNumberModel spinHeight = new SpinnerNumberModel(this.m_Height, 50, 500, 2);
        SpinnerNumberModel spinWidth = new SpinnerNumberModel(this.m_Width, 50, 500, 2);
        SpinnerNumberModel spinAxis = new SpinnerNumberModel(this.m_AxisWidth, 20, 300, 2);
        SpinnerNumberModel spinGrid = new SpinnerNumberModel((Number)this.m_NumHorizontal, Integer.valueOf(-1), null, (Number)1);
        this.m_WidthSpin = new JSpinner(spinWidth);
        this.m_HeightSpin = new JSpinner(spinHeight);
        this.m_AxisWidSpin = new JSpinner(spinAxis);
        this.m_GridSpin = new JSpinner(spinGrid);
        this.m_WidthSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                BoxPlotManager.this.spinWidthChange(arg0);
            }
        });
        this.m_HeightSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                BoxPlotManager.this.spinHeightChange(arg0);
            }
        });
        this.m_AxisWidSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                BoxPlotManager.this.spinAxisChange(arg0);
            }
        });
        this.m_GridSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BoxPlotManager.this.spinHorizontalChange(e);
            }
        });
        this.m_SameAxis = new JCheckBox();
        this.m_SameAxis.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                BoxPlotManager.this.sameAxisChange(arg0);
            }
        });
        this.m_FillCheck = new JCheckBox();
        this.m_FillCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BoxPlotManager.this.fillChange(e);
            }
        });
        this.m_Colorbutton = new JButton("color");
        this.m_Colorbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BoxPlotManager.this.colorChange();
            }
        });
        this.m_PanelParams.addParameter("Width of plot", (Component)this.m_WidthSpin);
        this.m_PanelParams.addParameter("Height of plot", (Component)this.m_HeightSpin);
        this.m_PanelParams.addParameter("Width of axis", (Component)this.m_AxisWidSpin);
        this.m_PanelParams.addParameter("Number in each row", (Component)this.m_GridSpin);
        this.m_PanelParams.addParameter("Use same axis", (Component)this.m_SameAxis);
        this.m_PanelParams.addParameter("Fill box", (Component)this.m_FillCheck);
        this.m_PanelParams.addParameter("Change color", (Component)this.m_Colorbutton);
        centre.add((Component)this.m_PanelParams, "Center");
        west.add((Component)top, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        west.add((Component)panel2, "Center");
        panel2.add((Component)centre, "North");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel2.add((Component)panel3, "Center");
        panel3.add((Component)bottom, "North");
        splitPane.setLeftComponent((Component)west);
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    protected void fillChange(ItemEvent val) {
        this.m_Fill = ((JCheckBox)val.getSource()).isSelected();
        this.update();
    }

    protected void colorChange() {
        Color newCol = JColorChooser.showDialog((Component)((Object)this), "Choose box color", this.m_Color);
        if (newCol != null) {
            this.m_Color = newCol;
        }
        this.update();
    }

    protected void updateGui() {
        this.m_SameAxis.setSelected(this.m_AxisSame);
        this.m_AxisWidSpin.setValue(this.m_AxisWidth);
        this.m_HeightSpin.setValue(this.m_Height);
        this.m_GridSpin.setValue(this.m_NumHorizontal);
        this.m_WidthSpin.setValue(this.m_Width);
        this.m_FillCheck.setSelected(this.m_Fill);
        if (this.m_Instances != null) {
            this.update();
        }
        this.updateButtons();
    }

    public void reset() {
        this.updateGui();
        for (int g = 0; g < this.m_Instances.numAttributes(); ++g) {
            this.m_Attributes.addElement(this.m_Instances.attribute(g).name());
        }
        if (this.m_Range != null) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            this.m_Range.setMax(this.m_Instances.numAttributes());
            for (int t = 0; t < this.m_Instances.size(); ++t) {
                if (!this.m_Range.isInRange(t)) continue;
                indices.add(t);
            }
            ArrayList<String> chosen = new ArrayList<String>();
            Iterator i$ = indices.iterator();
            while (i$.hasNext()) {
                int t = (Integer)i$.next();
                chosen.add((String)this.m_Attributes.get(t));
            }
            for (String s : chosen) {
                this.m_Chosen.addElement(s);
                this.m_Attributes.removeElement(s);
            }
        }
        this.update();
        this.updateButtons();
    }

    protected void addClicked() {
        if (this.m_AttributesDis.getSelectedIndex() == -1) {
            return;
        }
        int[] indices = this.m_AttributesDis.getSelectedIndices();
        Arrays.sort(indices);
        for (int index : indices) {
            this.m_Chosen.addElement(this.m_AttributesDis.getModel().getElementAt(index));
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_Attributes.remove(indices[i]);
        }
        this.updateButtons();
        this.update();
    }

    protected void removeClicked() {
        if (this.m_ChosenDis.getSelectedIndex() == -1) {
            return;
        }
        int[] indices = this.m_ChosenDis.getSelectedIndices();
        Arrays.sort(indices);
        for (int index : indices) {
            this.m_Attributes.addElement(this.m_ChosenDis.getModel().getElementAt(index));
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_Chosen.remove(indices[i]);
        }
        this.updateButtons();
        this.update();
    }

    protected void removeAllClicked() {
        this.m_Attributes.removeAllElements();
        this.m_Chosen.removeAllElements();
        for (int g = 0; g < this.m_Instances.numAttributes(); ++g) {
            this.m_Attributes.addElement(this.m_Instances.attribute(g).name());
        }
        this.updateButtons();
        this.update();
    }

    protected void addAllClicked() {
        this.m_Attributes.removeAllElements();
        this.m_Chosen.removeAllElements();
        for (int g = 0; g < this.m_Instances.numAttributes(); ++g) {
            this.m_Chosen.addElement(this.m_Instances.attribute(g).name());
        }
        this.updateButtons();
        this.update();
    }

    protected void spinWidthChange(ChangeEvent e) {
        JSpinner spin = (JSpinner)e.getSource();
        this.m_Width = (Integer)spin.getModel().getValue();
        if (this.m_Instances != null) {
            this.update();
        }
    }

    protected void spinHeightChange(ChangeEvent e) {
        JSpinner spin = (JSpinner)e.getSource();
        this.m_Height = (Integer)spin.getModel().getValue();
        if (this.m_Instances != null) {
            this.update();
        }
    }

    protected void spinAxisChange(ChangeEvent e) {
        JSpinner spin = (JSpinner)e.getSource();
        this.m_AxisWidth = (Integer)spin.getModel().getValue();
        if (this.m_Instances != null) {
            this.update();
        }
    }

    protected void spinHorizontalChange(ChangeEvent e) {
        JSpinner spin = (JSpinner)e.getSource();
        this.m_NumHorizontal = (Integer)spin.getModel().getValue();
        if (this.m_Instances != null) {
            this.update();
        }
    }

    protected void sameAxisChange(ItemEvent e) {
        boolean bl = this.m_AxisSame = e.getStateChange() == 1;
        if (this.m_Instances != null) {
            this.update();
        }
    }

    public void setBoxWidth(int val) {
        this.m_Width = val;
    }

    public int getBoxWidth() {
        return this.m_Width;
    }

    public void setBoxHeight(int val) {
        this.m_Height = val;
    }

    public int getBoxHeight() {
        return this.m_Height;
    }

    public void setAxisWidth(int val) {
        this.m_AxisWidth = val;
    }

    public int getAxisWidth() {
        return this.m_AxisWidth;
    }

    public void setNumHorizontal(int val) {
        this.m_NumHorizontal = val;
    }

    public int getNumHorizontal() {
        return this.m_NumHorizontal;
    }

    public void setSameAxis(boolean val) {
        this.m_AxisSame = val;
    }

    public boolean getSameAxis() {
        return this.m_AxisSame;
    }

    public void setRange(Range val) {
        this.m_Range = val;
    }

    public Range getRange() {
        return this.m_Range;
    }

    public void setFill(boolean val) {
        this.m_Fill = val;
    }

    public void setColor(Color val) {
        this.m_Color = val;
    }

    protected void update() {
        int numGraphs = this.m_Chosen.size();
        if (numGraphs != 0) {
            JPanel grid = this.m_NumHorizontal == 0 || this.m_NumHorizontal == -1 ? new JPanel(new GridLayout(1, 0)) : new JPanel(new GridLayout(0, this.m_NumHorizontal));
            this.m_Centre.removeAll();
            BaseScrollPane scrollPane = new BaseScrollPane((Component)grid);
            Dimension dim = new Dimension(this.m_Width, this.m_Height);
            Double max = null;
            Double min = null;
            if (this.m_AxisSame) {
                for (int i = 0; i < this.m_Instances.numAttributes(); ++i) {
                    double[] data = this.m_Instances.attributeToDoubleArray(i);
                    double tempMax = StatUtils.max((double[])data);
                    double tempMin = StatUtils.min((double[])data);
                    if (max == null) {
                        max = tempMax;
                    }
                    if (min == null) {
                        min = tempMin;
                    }
                    if (tempMax > max) {
                        max = tempMax;
                    }
                    if (!(tempMin < min)) continue;
                    min = tempMin;
                }
            }
            JPanel scrollHold = new JPanel();
            scrollHold.add((Component)scrollPane);
            BaseScrollPane holdScroll = new BaseScrollPane((Component)scrollHold);
            this.m_Centre.add((Component)holdScroll, "Center");
            for (int r = 0; r < this.m_Chosen.size(); ++r) {
                Attribute toPlot = this.m_Instances.attribute((String)this.m_Chosen.getElementAt(r));
                BoxPlotGraph graph = new BoxPlotGraph();
                graph.pass(this.m_Instances, toPlot);
                graph.setPreferredSize(dim);
                if (this.m_AxisSame) {
                    graph.axisSame(max, min);
                }
                graph.setColor(this.m_Color);
                graph.setFill(this.m_Fill);
                graph.setAxisWidth(Axis.LEFT, this.m_AxisWidth);
                graph.addPaintListener(this);
                JPanel graphPanel = new JPanel(new BorderLayout());
                JLabel title = new JLabel(toPlot.name(), null, 0);
                graphPanel.add((Component)title, "North");
                graphPanel.add((Component)((Object)graph), "Center");
                graphPanel.setBorder(BorderFactory.createLineBorder(Color.black));
                grid.add(graphPanel);
            }
        } else {
            this.m_Centre.removeAll();
        }
        this.repaint();
        this.revalidate();
    }

    public void painted(PaintEvent e) {
        Graphics g = e.getGraphics();
        BoxPlotGraph graph = (BoxPlotGraph)((Object)e.getSource());
        if (e.getPaintMoment() == PaintEvent.PaintMoment.PAINT) {
            graph.paintPlot(g);
        }
    }
}

