/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.histogram;

import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import adams.data.statistics.StatUtils;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.histogram.HistogramOptions;
import adams.gui.visualization.stats.histogram.HistogramPanel;
import adams.gui.visualization.stats.paintlet.HistogramPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import weka.core.Instances;

public class Histogram
extends PaintablePanel {
    private static final long serialVersionUID = -4366437103496819542L;
    protected Instances m_Instances;
    protected Double[] m_Array;
    protected HistogramPanel m_Plot;
    protected HistogramPaintlet m_Val;
    protected HistogramOptions m_HistOptions;
    protected int m_Index;
    protected String m_DataName;
    protected double[][] m_Plotdata;
    protected double m_BinWidth;
    protected String m_Name;

    protected void initialize() {
        super.initialize();
        this.m_HistOptions = new HistogramOptions();
        this.m_Instances = null;
        this.m_Array = null;
        this.m_DataName = "";
        this.m_Index = 0;
        this.m_Plotdata = new double[0][2];
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new HistogramPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.m_Val = new HistogramPaintlet();
        this.m_Val.setPanel(this);
        this.add((Component)((Object)this.m_Plot), "Center");
    }

    public void setOptions(HistogramOptions val) {
        this.m_HistOptions = val;
        this.removePaintlet((Paintlet)this.m_Val);
        this.m_Val = (HistogramPaintlet)this.m_HistOptions.getPaintlet().shallowCopy(true);
        this.m_Val.setPanel(this);
    }

    public HistogramOptions getOptions() {
        return this.m_HistOptions;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
        this.m_Array = null;
        this.update();
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setArray(Double[] value) {
        this.m_Array = value;
        this.m_Instances = null;
        this.update();
    }

    public Double[] getArray() {
        return this.m_Array;
    }

    public void setDataName(String value) {
        this.m_DataName = value;
    }

    public String getDataName() {
        return this.m_DataName;
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        Number[] numData;
        ArrayHistogram aHist = new ArrayHistogram();
        if (this.m_Instances != null) {
            numData = StatUtils.toNumberArray((double[])this.m_Instances.attributeToDoubleArray(this.m_Index));
            this.m_Name = this.m_Instances.attribute(this.m_Index).name();
        } else {
            numData = this.m_Array;
            this.m_Name = "Data";
        }
        if (this.m_DataName.length() > 0) {
            this.m_Name = this.m_DataName;
        }
        if (numData == null) {
            this.m_Plotdata = new double[0][2];
            return;
        }
        aHist.add((Serializable[])numData);
        aHist.setBinWidth(this.m_HistOptions.m_WidthBin);
        aHist.setNumBins(this.m_HistOptions.m_NumBins);
        ArrayHistogram.BinCalculation bc = this.m_HistOptions.m_BoxType == HistogramOptions.BoxType.DENSITY ? ArrayHistogram.BinCalculation.DENSITY : ArrayHistogram.BinCalculation.MANUAL;
        aHist.setBinCalculation(bc);
        AbstractArrayStatistic.StatisticContainer cont = aHist.calculate();
        int numBins = (Integer)cont.getMetaData("num-bins");
        double[] binX = (double[])cont.getMetaData("bin-x");
        this.m_BinWidth = (Double)cont.getMetaData("bin-width");
        this.m_Plotdata = new double[numBins][2];
        for (int i = 0; i < this.m_Plotdata.length; ++i) {
            this.m_Plotdata[i][1] = (Double)cont.getCell(0, i);
            this.m_Plotdata[i][0] = binX[i];
        }
        AxisPanel axisBottom = this.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.getPlot().getAxis(Axis.LEFT);
        axisBottom.setNthValueToShow(this.m_Plotdata.length / 5);
        axisBottom.setMinimum(this.m_Plotdata[0][0]);
        axisBottom.setMaximum(this.m_Plotdata[this.m_Plotdata.length - 1][0] + this.m_BinWidth);
        axisBottom.setAxisName(this.m_Name);
        axisBottom.setNumTicks(this.m_Plotdata.length);
        axisLeft.setMinimum(0.0);
        double max = this.m_Plotdata[1][0];
        for (int i = 1; i < this.m_Plotdata.length; ++i) {
            if (!(this.m_Plotdata[i][1] > max)) continue;
            max = this.m_Plotdata[i][1];
        }
        axisLeft.setMaximum(max / this.m_BinWidth);
        axisLeft.setAxisName("Frequency");
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null;
    }

    public void setIndex(int val) {
        this.m_Index = val;
        this.update();
    }

    public int getIndex() {
        return this.m_Index;
    }

    public double[][] getPlotdata() {
        return this.m_Plotdata;
    }

    public double getBinWidth() {
        return this.m_BinWidth;
    }
}

