/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.histogram.Histogram;
import adams.gui.visualization.stats.paintlet.AbstractColorPaintlet;
import java.awt.Color;
import java.awt.Graphics;

public class HistogramPaintlet
extends AbstractColorPaintlet {
    private static final long serialVersionUID = -3474738819482043957L;
    protected boolean m_Fill;
    protected Color m_FillColor;

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("fill-bins", "fillBins", (Object)true);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)Color.RED);
    }

    public void setFillBins(boolean val) {
        this.m_Fill = val;
        this.memberChanged();
    }

    public boolean getFillBins() {
        return this.m_Fill;
    }

    public String fillBinsTipText() {
        return "Fill the bins with color";
    }

    public void setFillColor(Color val) {
        this.m_FillColor = val;
        this.memberChanged();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "color for filling the bins";
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        double[][] data = ((Histogram)this.getPanel()).getPlotdata();
        double binWidth = ((Histogram)this.getPanel()).getBinWidth();
        if (data != null && data.length > 0) {
            AxisPanel axisBottom = this.getPlot().getAxis(Axis.BOTTOM);
            AxisPanel axisLeft = this.getPlot().getAxis(Axis.LEFT);
            for (int i = 0; i < data.length; ++i) {
                double val = data[i][1] / binWidth;
                if (this.m_Fill) {
                    g.setColor(this.m_FillColor);
                    g.fillRect(axisBottom.valueToPos(data[i][0]), axisLeft.valueToPos(val), axisBottom.valueToPos(data[i][0] + binWidth) - axisBottom.valueToPos(data[i][0]), axisLeft.valueToPos(axisLeft.getMinimum()) - axisLeft.valueToPos(val));
                }
                g.setColor(this.m_Color);
                g.drawRect(axisBottom.valueToPos(data[i][0]), axisLeft.valueToPos(val), axisBottom.valueToPos(data[i][0] + binWidth) - axisBottom.valueToPos(data[i][0]), axisLeft.valueToPos(axisLeft.getMinimum()) - axisLeft.valueToPos(val));
            }
        }
    }

    public String globalInfo() {
        return "Paints the histogram";
    }
}

