/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.fourinone;

import adams.data.statistics.StatUtils;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.fourinone.VersusOrderOptions;
import adams.gui.visualization.stats.fourinone.VersusOrderPanel;
import adams.gui.visualization.stats.paintlet.VsOrderPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import weka.core.Instances;

public class VersusOrder
extends PaintablePanel {
    private static final long serialVersionUID = 6182760237927361108L;
    protected Instances m_Instances;
    protected VersusOrderPanel m_Plot;
    protected VsOrderPaintlet m_Val;
    protected VersusOrderOptions m_VsOrderOptions;
    protected int m_Index;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new VersusOrderPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.add((Component)((Object)this.m_Plot), "Center");
        this.m_Val = new VsOrderPaintlet();
        this.m_Val.setPanel(this);
    }

    public void setOptions(VersusOrderOptions val) {
        this.m_VsOrderOptions = val;
        this.removePaintlet((Paintlet)this.m_Val);
        this.m_Val = (VsOrderPaintlet)this.m_VsOrderOptions.getPaintlet().shallowCopy(true);
        this.m_Val.setPanel(this);
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        if (this.m_Instances != null) {
            this.m_Val.setInstances(this.m_Instances);
            this.m_Val.setIndex(this.m_Index);
            this.m_Val.setRepaintOnChange(true);
            AxisPanel axisBottom = this.getPlot().getAxis(Axis.BOTTOM);
            AxisPanel axisLeft = this.getPlot().getAxis(Axis.LEFT);
            double[] residuals = this.m_Instances.attributeToDoubleArray(this.m_Index);
            double minY = StatUtils.min((double[])residuals);
            double maxY = StatUtils.max((double[])residuals);
            axisBottom.setMinimum(0.0);
            axisBottom.setMaximum((double)(residuals.length - 1));
            axisLeft.setMinimum(minY);
            axisLeft.setMaximum(maxY);
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null && this.m_Instances != null;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public void setInstances(Instances inst) {
        this.m_Instances = inst;
    }

    public void setIndex(int val) {
        this.m_Index = val;
    }
}

