/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AntiAliasingPaintlet;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.AbstractColorPaintlet;
import java.awt.Color;
import java.awt.Graphics;
import weka.core.Instances;

public abstract class AbstractZScorePaintlet
extends AbstractColorPaintlet
implements AntiAliasingPaintlet {
    private static final long serialVersionUID = 6918445466346742103L;
    protected int m_Index;
    protected double[] m_Data;
    protected AxisPanel m_AxisLeft;
    protected AxisPanel m_AxisBottom;
    protected Color m_LineColor;
    protected boolean m_AntiAliasingEnabled;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("line-color", "lineColor", (Object)Color.LIGHT_GRAY);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    protected void initialize() {
        super.initialize();
        this.m_Index = 0;
    }

    public void setLineColor(Color val) {
        this.m_LineColor = val;
    }

    public Color getLineColor() {
        return this.m_LineColor;
    }

    public String lineColorTipText() {
        return "Color for drawing the lines.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        if (this.m_Instances != null) {
            this.drawData(g);
        }
    }

    public void setIndex(int ind) {
        this.m_Index = ind;
        this.memberChanged();
    }

    public void parameters(Instances inst, int ind) {
        this.m_Instances = inst;
        this.m_Index = ind;
    }

    protected void drawData(Graphics g) {
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        if (this.m_Instances != null) {
            g.setColor(Color.BLACK);
            this.m_Data = this.m_Instances.attributeToDoubleArray(this.m_Index);
            this.m_AxisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            this.m_AxisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
        }
    }
}

