/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.core.GUIHelper;
import adams.gui.visualization.core.AntiAliasingPaintlet;
import adams.gui.visualization.stats.paintlet.AbstractOverlayPaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class DiagonalPaintlet
extends AbstractOverlayPaintlet
implements AntiAliasingPaintlet {
    private static final long serialVersionUID = 2136293814736622480L;
    protected boolean m_Indicator;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for displaying the diagonal overlay on the scatter plot.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    @Override
    protected void drawData(Graphics g) {
        if (this.m_Calculated) {
            GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
            g.setColor(this.m_Color);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            g2d.drawLine(0, this.m_AxisLeft.valueToPos(this.m_AxisBottom.posToValue(0)), this.m_AxisBottom.getWidth(), this.m_AxisLeft.valueToPos(this.m_AxisBottom.posToValue(this.m_AxisBottom.getWidth())));
            if (this.m_Indicator) {
                boolean through = false;
                int pos = Integer.MIN_VALUE;
                for (int i = 0; i < this.m_AxisBottom.getWidth(); ++i) {
                    int oldPos = pos;
                    pos = this.m_AxisLeft.valueToPos(this.m_AxisBottom.posToValue(i));
                    if ((pos <= 0 || pos >= this.m_AxisLeft.getHeight()) && (oldPos <= this.m_AxisLeft.getHeight() || pos >= 0)) continue;
                    through = true;
                    break;
                }
                if (!through) {
                    double gradient = -((double)(this.m_AxisLeft.valueToPos(this.m_AxisBottom.posToValue(100)) - this.m_AxisLeft.valueToPos(this.m_AxisBottom.posToValue(0))) / 100.0);
                    if (this.m_AxisLeft.valueToPos(this.m_AxisBottom.posToValue(0)) < 0) {
                        if (gradient > 1.0) {
                            int lengthY = this.m_AxisLeft.getHeight();
                            int lengthX = (int)Math.round((double)this.m_AxisLeft.getHeight() / gradient);
                            if (lengthX < this.m_AxisBottom.getWidth()) {
                                g2d.drawLine(1, 0, 1, lengthY);
                                g2d.drawLine(0, 1, lengthX + 1, 1);
                            } else {
                                g2d.drawLine(0, 1, this.m_AxisBottom.getWidth(), 1);
                                g2d.drawLine(1, 0, 1, (int)Math.round((double)this.m_AxisBottom.getWidth() * gradient));
                            }
                        } else {
                            int lengthX = this.m_AxisBottom.getWidth();
                            int lengthY = (int)Math.round((double)this.m_AxisBottom.getWidth() * gradient);
                            if (lengthY < this.m_AxisLeft.getHeight()) {
                                g2d.drawLine(0, 1, lengthX, 1);
                                g2d.drawLine(1, 0, 1, lengthY + 1);
                            } else {
                                g2d.drawLine(1, 0, 1, this.m_AxisLeft.getHeight());
                                g2d.drawLine(0, 1, (int)Math.round((double)this.m_AxisLeft.getHeight() / gradient), 1);
                            }
                        }
                    } else if (gradient > 1.0) {
                        int lengthY = this.m_AxisLeft.getHeight();
                        int lengthX = (int)Math.round((double)this.m_AxisLeft.getHeight() / gradient);
                        if (lengthX < this.m_AxisBottom.getWidth()) {
                            g2d.drawLine(this.m_AxisBottom.getWidth() - 1, 0, this.m_AxisBottom.getWidth() - 1, lengthY);
                            g2d.drawLine(this.m_AxisBottom.getWidth() - (lengthX + 1), this.m_AxisLeft.getHeight() - 1, this.m_AxisBottom.getWidth(), this.m_AxisLeft.getHeight() - 1);
                        } else {
                            g2d.drawLine(0, this.m_AxisLeft.getHeight() - 1, this.m_AxisBottom.getWidth(), this.m_AxisLeft.getHeight() - 1);
                            g2d.drawLine(this.m_AxisBottom.getWidth() - 1, this.m_AxisLeft.getHeight() - (int)Math.round((double)this.m_AxisBottom.getWidth() * gradient), this.m_AxisBottom.getWidth() - 1, this.m_AxisLeft.getHeight());
                        }
                    } else {
                        int lengthX = this.m_AxisBottom.getWidth();
                        int lengthY = (int)Math.round((double)this.m_AxisBottom.getWidth() * gradient);
                        if (lengthY < this.m_AxisLeft.getHeight()) {
                            g2d.drawLine(0, this.m_AxisLeft.getHeight() - 1, lengthX, this.m_AxisLeft.getHeight() - 1);
                            g2d.drawLine(this.m_AxisBottom.getWidth() - 1, this.m_AxisLeft.getHeight() - (lengthY + 1), this.m_AxisBottom.getWidth() - 1, this.m_AxisLeft.getHeight());
                        } else {
                            g2d.drawLine(this.m_AxisBottom.getWidth() - 1, 0, this.m_AxisBottom.getWidth() - 1, this.m_AxisLeft.getHeight());
                            g2d.drawLine(this.m_AxisBottom.getWidth() - (int)Math.round((double)this.m_AxisLeft.getHeight() / gradient), this.m_AxisLeft.getHeight() - 1, this.m_AxisBottom.getWidth(), this.m_AxisLeft.getHeight() - 1);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void calculate() {
        super.calculate();
        this.m_Calculated = true;
    }

    @Override
    public void setIndicator(boolean val) {
        this.m_Indicator = val;
        this.memberChanged();
    }
}

