/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.conversion.SpreadSheetToWekaInstances;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.tools.spreadsheetviewer.AbstractViewPlugin;
import adams.gui.visualization.stats.paintlet.ScatterPaintletCircle;
import adams.gui.visualization.stats.scatterplot.Matrix;
import weka.core.Instances;

public class MatrixPlot
extends AbstractViewPlugin {
    private static final long serialVersionUID = 9089022183434856748L;
    protected Instances m_Data;

    public String globalInfo() {
        return "Generates a matrix plot for the data.";
    }

    public String getMenuText() {
        return "Matrix plot";
    }

    public String getMenuIcon() {
        return "matrixplot.png";
    }

    protected String check(SpreadSheet sheet) {
        String result = super.check(sheet);
        if (result == null) {
            this.m_Data = null;
            SpreadSheetToWekaInstances convert = new SpreadSheetToWekaInstances();
            convert.setInput((Object)sheet);
            result = convert.convert();
            if (result == null) {
                this.m_Data = (Instances)convert.getOutput();
            }
            convert.cleanUp();
        }
        return result;
    }

    protected BasePanel doGenerate(SpreadSheet sheet) {
        Matrix result = new Matrix();
        result.setInstances(this.m_Data);
        result.setPercent(100);
        result.setPaintlet(new ScatterPaintletCircle());
        result.setPlotSize(100);
        result.reset();
        return result;
    }
}

