/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spc;

import adams.data.spc.AbstractControlChart;
import adams.data.spc.ControlChartWithSampleSize;

public abstract class AbstractControlChartWithSampleSize
extends AbstractControlChart
implements ControlChartWithSampleSize {
    private static final long serialVersionUID = 6551757750425372768L;
    protected int m_SampleSize;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sample-size", "sampleSize", (Object)this.getDefaultSampleSize(), this.getDefaultSampleSizeLowerLimit(), this.getDefaultSampleSizeUpperLimit());
    }

    protected Number getDefaultSampleSizeLowerLimit() {
        return 1;
    }

    protected Number getDefaultSampleSizeUpperLimit() {
        return null;
    }

    protected abstract int getDefaultSampleSize();

    @Override
    public abstract String getName();

    @Override
    public void setSampleSize(int value) {
        if (this.getDefaultSampleSizeLowerLimit() != null && value < this.getDefaultSampleSizeLowerLimit().intValue()) {
            this.getLogger().warning("Sample size must be at least " + this.getDefaultSampleSizeLowerLimit() + ", provided: " + value);
            return;
        }
        if (this.getDefaultSampleSizeUpperLimit() != null && value > this.getDefaultSampleSizeUpperLimit().intValue()) {
            this.getLogger().warning("Sample size must be at most " + this.getDefaultSampleSizeUpperLimit() + ", provided: " + value);
            return;
        }
        this.m_SampleSize = value;
        this.reset();
    }

    @Override
    public int getSampleSize() {
        return this.m_SampleSize;
    }

    @Override
    public String sampleSizeTipText() {
        return "The sample size to use.";
    }
}

