/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spc;

import adams.core.TechnicalInformation;
import adams.data.spc.AbstractControlChartWithSampleSize;
import adams.data.spc.Limits;
import adams.data.spc.SamplesControlChart;
import adams.data.statistics.SPCUtils;
import java.util.ArrayList;
import java.util.List;

public class XBarSChart
extends AbstractControlChartWithSampleSize
implements SamplesControlChart {
    private static final long serialVersionUID = 4352909660548550374L;
    protected boolean m_StandardDeviation;

    public String globalInfo() {
        return "Generates data for an XBar S chart.\n\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("standard-deviation", "standardDeviation", (Object)false);
    }

    @Override
    protected int getDefaultSampleSize() {
        return -1;
    }

    @Override
    protected Number getDefaultSampleSizeLowerLimit() {
        return -1;
    }

    @Override
    public String sampleSizeTipText() {
        return "The sample size to use; use < 0 to automatically determine from data.";
    }

    public void setStandardDeviation(boolean value) {
        this.m_StandardDeviation = value;
        this.reset();
    }

    public boolean getStandardDeviation() {
        return this.m_StandardDeviation;
    }

    public String standardDeviationTipText() {
        return "If enabled, standard deviation data instead of mean data is generated.";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "QICacros");
        result.setValue(TechnicalInformation.Field.TITLE, "X bar S Chart Formulas");
        result.setValue(TechnicalInformation.Field.URL, "http://www.qimacros.com/control-chart-formulas/x-bar-s-chart-formula/");
        return result;
    }

    @Override
    public String getName() {
        return "Xbar S chart (" + (this.m_StandardDeviation ? "standard deviation" : "mean") + ")";
    }

    protected int getActualSampleSize(Number[][] data) {
        if (this.m_SampleSize > 0) {
            return this.m_SampleSize;
        }
        return data[0].length;
    }

    @Override
    public List<Limits> calculate(Number[][] data) {
        ArrayList<Limits> result = new ArrayList<Limits>();
        if (this.m_StandardDeviation) {
            result.add(new Limits(SPCUtils.stats_x_bar_s_s((Number[][])data, (int)this.getActualSampleSize(data))));
        } else {
            result.add(new Limits(SPCUtils.stats_x_bar_s_x((Number[][])data, (int)this.getActualSampleSize(data))));
        }
        return result;
    }

    @Override
    public double[] prepare(Number[][] data) {
        if (this.m_StandardDeviation) {
            return SPCUtils.prepare_data_x_bar_s_s((Number[][])data, (int)this.getActualSampleSize(data));
        }
        return SPCUtils.prepare_data_x_bar_rs_x((Number[][])data, (int)this.getActualSampleSize(data));
    }
}

