/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.controlchartplot;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.flow.sink.controlchartplot.AbstractControlChartPaintlet;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.LineHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.List;

public class ChartPaintlet
extends AbstractControlChartPaintlet
implements AntiAliasingSupporter,
HitDetectorSupporter<AbstractXYSequencePointHitDetector> {
    private static final long serialVersionUID = 8242948176244747138L;
    protected int m_MarkerExtent;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for generating a line plot for X-Y sequences.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("markers-extent", "markerExtent", (Object)7, (Number)0, null);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setMarkerExtent(int value) {
        if (value >= 0) {
            this.m_MarkerExtent = value;
            this.memberChanged();
        } else {
            System.err.println("Marker extent must be >= 0 (provided: " + value + ")!");
        }
    }

    public int getMarkerExtent() {
        return this.m_MarkerExtent;
    }

    public String markerExtentTipText() {
        return "The size of the markers in pixels.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public AbstractXYSequencePointHitDetector newHitDetector() {
        return new LineHitDetector();
    }

    protected void drawData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data, Color color) {
        int end;
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        g.setColor(color);
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        int start = XYSequenceUtils.findClosestX((List)points, (double)Math.floor(axisX.getMinimum()));
        if (start > 0) {
            --start;
        }
        if ((end = XYSequenceUtils.findClosestX((List)points, (double)Math.ceil(axisX.getMaximum()))) < data.size() - 1) {
            ++end;
        }
        int prevX = axisX.valueToPos(((XYSequencePoint)points.get(start)).getX());
        int prevY = axisY.valueToPos(((XYSequencePoint)points.get(start)).getY());
        for (int i = start; i <= end; ++i) {
            XYSequencePoint curr = (XYSequencePoint)points.get(i);
            HashMap meta = null;
            if (curr instanceof SequencePlotPoint) {
                meta = ((SequencePlotPoint)curr).getMetaData();
            }
            int currX = axisX.valueToPos(XYSequencePoint.toDouble((Double)curr.getX()).doubleValue());
            int currY = axisY.valueToPos(XYSequencePoint.toDouble((Double)curr.getY()).doubleValue());
            g.drawLine(prevX, prevY, currX, currY);
            if (meta != null && ((Boolean)meta.get("violation")).booleanValue()) {
                g.setColor(Color.RED);
            } else {
                g.setColor(color);
            }
            g.drawRect(currX - this.m_MarkerExtent / 2, currY - this.m_MarkerExtent / 2, this.m_MarkerExtent - 1, this.m_MarkerExtent - 1);
            prevX = currX;
            prevY = currY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        XYSequenceContainerManager xYSequenceContainerManager = this.getActualContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < this.getActualContainerManager().count(); ++i) {
                XYSequence data;
                if (!this.getActualContainerManager().isVisible(i) || (data = ((XYSequenceContainer)this.getActualContainerManager().get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawData(g, moment, data, this.getColor(i));
                    continue;
                }
            }
        }
    }
}

