/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.controlchartplot;

import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.data.sequence.XYSequenceUtils;
import adams.flow.sink.controlchartplot.AbstractControlChartPaintlet;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.List;

public class LimitPaintlet
extends AbstractControlChartPaintlet
implements AntiAliasingSupporter,
HitDetectorSupporter<AbstractXYSequencePointHitDetector> {
    private static final long serialVersionUID = 8242948176244747138L;
    protected Color m_ColorLower;
    protected Color m_ColorCenter;
    protected Color m_ColorUpper;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for generating a limits of a control chart.\n";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-lower", "colorLower", (Object)Color.RED.darker());
        this.m_OptionManager.add("color-center", "colorCenter", (Object)Color.LIGHT_GRAY);
        this.m_OptionManager.add("color-upper", "colorUpper", (Object)Color.RED.darker());
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setColorLower(Color value) {
        this.m_ColorLower = value;
        this.memberChanged();
    }

    public Color getColorLower() {
        return this.m_ColorLower;
    }

    public String colorLowerTipText() {
        return "The color to use for drawing the lower limit.";
    }

    public void setColorCenter(Color value) {
        this.m_ColorCenter = value;
        this.memberChanged();
    }

    public Color getColorCenter() {
        return this.m_ColorCenter;
    }

    public String colorCenterTipText() {
        return "The color to use for drawing the center.";
    }

    public void setColorUpper(Color value) {
        this.m_ColorUpper = value;
        this.memberChanged();
    }

    public Color getColorUpper() {
        return this.m_ColorUpper;
    }

    public String colorUpperTipText() {
        return "The color to use for drawing the upper limit.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public AbstractXYSequencePointHitDetector newHitDetector() {
        return null;
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PRE_PAINT;
    }

    protected void drawData(Graphics g, PaintEvent.PaintMoment moment, XYSequence data) {
        int end;
        List points = data.toList();
        AxisPanel axisX = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisY = this.getPanel().getPlot().getAxis(Axis.LEFT);
        GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
        int start = XYSequenceUtils.findClosestX((List)points, (double)Math.floor(axisX.getMinimum()));
        if (start > 0) {
            --start;
        }
        if ((end = XYSequenceUtils.findClosestX((List)points, (double)Math.ceil(axisX.getMaximum()))) < data.size() - 1) {
            ++end;
        }
        for (int i = start + 1; i <= end; ++i) {
            XYSequencePoint prev = (XYSequencePoint)points.get(i - 1);
            if (!(prev instanceof SequencePlotPoint)) continue;
            HashMap prevMeta = ((SequencePlotPoint)prev).getMetaData();
            XYSequencePoint curr = (XYSequencePoint)points.get(i);
            if (!(curr instanceof SequencePlotPoint)) continue;
            HashMap currMeta = ((SequencePlotPoint)curr).getMetaData();
            boolean isStart = i == start + 1;
            boolean isEnd = i == end;
            int prevX = axisX.valueToPos(XYSequencePoint.toDouble((Double)prev.getX()).doubleValue());
            int currX = axisX.valueToPos(XYSequencePoint.toDouble((Double)curr.getX()).doubleValue());
            int prevY = axisY.valueToPos(XYSequencePoint.toDouble(prevMeta.get("lower")).doubleValue());
            int currY = axisY.valueToPos(XYSequencePoint.toDouble(currMeta.get("lower")).doubleValue());
            g.setColor(this.m_ColorLower);
            g.drawLine(isStart ? axisX.valueToPos(axisX.getActualMinimum()) : prevX, prevY, prevX + (currX - prevX) / 2, prevY);
            if (prevY != currY) {
                g.drawLine(prevX + (currX - prevX) / 2, prevY, prevX + (currX - prevX) / 2, currY);
            }
            g.drawLine(prevX + (currX - prevX) / 2, currY, isEnd ? axisX.valueToPos(axisX.getActualMaximum()) : currX, currY);
            prevY = axisY.valueToPos(XYSequencePoint.toDouble(prevMeta.get("center")).doubleValue());
            currY = axisY.valueToPos(XYSequencePoint.toDouble(currMeta.get("center")).doubleValue());
            g.setColor(this.m_ColorCenter);
            g.drawLine(isStart ? axisX.valueToPos(axisX.getActualMinimum()) : prevX, prevY, prevX + (currX - prevX) / 2, prevY);
            if (prevY != currY) {
                g.drawLine(prevX + (currX - prevX) / 2, prevY, prevX + (currX - prevX) / 2, currY);
            }
            g.drawLine(prevX + (currX - prevX) / 2, currY, isEnd ? axisX.valueToPos(axisX.getActualMaximum()) : currX, currY);
            prevY = axisY.valueToPos(XYSequencePoint.toDouble(prevMeta.get("upper")).doubleValue());
            currY = axisY.valueToPos(XYSequencePoint.toDouble(currMeta.get("upper")).doubleValue());
            g.setColor(this.m_ColorUpper);
            g.drawLine(isStart ? axisX.valueToPos(axisX.getActualMinimum()) : prevX, prevY, prevX + (currX - prevX) / 2, prevY);
            if (prevY != currY) {
                g.drawLine(prevX + (currX - prevX) / 2, prevY, prevX + (currX - prevX) / 2, currY);
            }
            g.drawLine(prevX + (currX - prevX) / 2, currY, isEnd ? axisX.valueToPos(axisX.getActualMaximum()) : currX, currY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        XYSequenceContainerManager xYSequenceContainerManager = this.getActualContainerManager();
        synchronized (xYSequenceContainerManager) {
            for (int i = 0; i < this.getActualContainerManager().count(); ++i) {
                XYSequence data;
                if (!this.getActualContainerManager().isVisible(i) || this.getActualContainerManager().isFiltered() && !this.getActualContainerManager().isFiltered(i) || (data = ((XYSequenceContainer)this.getActualContainerManager().get(i)).getData()).size() == 0) continue;
                XYSequence xYSequence = data;
                synchronized (xYSequence) {
                    this.drawData(g, moment, data);
                    continue;
                }
            }
        }
    }
}

