/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.scatterplot;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;

public class ScatterPlotPanel
extends PlotPanel {
    private static final long serialVersionUID = 107298737463861170L;
    protected SpreadSheet m_Data;
    protected int m_XIndex;
    protected int m_YIndex;

    protected void initialize() {
        super.initialize();
        this.m_XIndex = 0;
        this.m_YIndex = 0;
    }

    protected void initGUI() {
        super.initGUI();
        this.setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
        this.setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
        this.m_AxisLeft.setNumberFormat("#.##");
        this.m_AxisBottom.setNumberFormat("#.##");
    }

    public void setData(SpreadSheet value) {
        this.m_Data = value;
    }

    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void reset() {
        double[] dataX = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_XIndex);
        double[] dataY = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_YIndex);
        double xMin = StatUtils.min((double[])dataX);
        double xMax = StatUtils.max((double[])dataX);
        double yMin = StatUtils.min((double[])dataY);
        double yMax = StatUtils.max((double[])dataY);
        this.m_AxisLeft.setMinimum(yMin);
        this.m_AxisLeft.setMaximum(yMax);
        this.m_AxisBottom.setMinimum(xMin);
        this.m_AxisBottom.setMaximum(xMax);
        this.m_AxisLeft.setBottomMargin(0.1);
        this.m_AxisLeft.setTopMargin(0.1);
        this.m_AxisBottom.setBottomMargin(0.1);
        this.m_AxisBottom.setTopMargin(0.1);
        this.m_AxisLeft.setAxisName(this.m_Data.getColumnName(this.m_YIndex));
        this.m_AxisBottom.setAxisName(this.m_Data.getColumnName(this.m_XIndex));
        this.m_AxisLeft.setTickGenerator((TickGenerator)new FancyTickGenerator());
        this.m_AxisBottom.setTickGenerator((TickGenerator)new FancyTickGenerator());
        this.m_AxisLeft.setNthValueToShow(1);
        this.m_AxisBottom.setNthValueToShow(2);
        this.validate();
        this.repaint();
    }

    public void setX(int val) {
        this.m_XIndex = val;
        this.reset();
    }

    public int getX() {
        return this.m_XIndex;
    }

    public void setY(int val) {
        this.m_YIndex = val;
        this.reset();
    }

    public int getY() {
        return this.m_YIndex;
    }
}

