/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spc;

import adams.data.spc.AbstractViolationFinder;
import adams.data.spc.Limits;
import gnu.trove.list.array.TIntArrayList;

public class OnOneSideViolations
extends AbstractViolationFinder {
    private static final long serialVersionUID = 6050852088287348188L;
    protected int m_MinPoints;

    public String globalInfo() {
        return "Flags a data point as violation if it is the start of consecutive sequence (of specified minimum length) of points that are all on one side.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-points", "minPoints", (Object)7, (Number)1, null);
    }

    public void setMinPoints(int value) {
        if (value >= 1) {
            this.m_MinPoints = value;
            this.reset();
        } else {
            this.getLogger().warning("Minimum number of points must be 1, provided: " + value);
        }
    }

    public int getMinPoints() {
        return this.m_MinPoints;
    }

    public String minPointsTipText() {
        return "The minimum number of points that have to be on one side.";
    }

    @Override
    protected int[] doFind(double[] data, Limits[] limits) {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < data.length - this.m_MinPoints; ++i) {
            boolean mixed = false;
            for (int n = 0; n < this.m_MinPoints - 1; ++n) {
                if (limits.length == data.length) {
                    if (!((data[n] - limits[n].getCenter()) * (data[n + 1] - limits[n].getCenter()) < 0.0)) continue;
                    mixed = true;
                    break;
                }
                if (!((data[n] - limits[0].getCenter()) * (data[n + 1] - limits[0].getCenter()) < 0.0)) continue;
                mixed = true;
                break;
            }
            if (mixed) continue;
            result.add(i);
        }
        return result.toArray();
    }
}

