/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.NamedCounter;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.DecimalFormatString;
import adams.data.container.DataPoint;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePointComparator;
import adams.data.spc.ControlChart;
import adams.data.spc.IndividualsControlChart;
import adams.data.spc.Limits;
import adams.data.spc.MatrixControlChart;
import adams.data.spc.NullViolations;
import adams.data.spc.ViolationFinder;
import adams.data.statistics.StatUtils;
import adams.flow.container.ControlChartContainer;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Compatibility;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.controlchartplot.AbstractControlChartPaintlet;
import adams.flow.sink.controlchartplot.ChartPaintlet;
import adams.flow.sink.controlchartplot.LimitPaintlet;
import adams.flow.sink.sequenceplotter.AbstractSequencePostProcessor;
import adams.flow.sink.sequenceplotter.MarkerPaintlet;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.NullClickAction;
import adams.flow.sink.sequenceplotter.PassThrough;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.flow.sink.sequenceplotter.VerticalMarkers;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.axis.AbstractLimitedTickGenerator;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.MultiPaintlet;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.constant.Constable;
import java.util.HashMap;

public class ControlChartPlot
extends AbstractGraphicalDisplay {
    private static final long serialVersionUID = 3238389451500168650L;
    protected ViolationFinder m_ViolationFinder;
    protected AbstractControlChartPaintlet m_Paintlet;
    protected AbstractControlChartPaintlet m_LimitPaintlet;
    protected MarkerPaintlet m_SeparatorPaintlet;
    protected AbstractColorProvider m_ColorProvider;
    protected MouseClickAction m_MouseClickAction;
    protected String m_Title;
    protected AxisPanelOptions m_AxisX;
    protected AxisPanelOptions m_AxisY;
    protected AbstractSequencePostProcessor m_PostProcessor;
    protected ControlChart m_Chart;
    protected String m_ChartName;
    protected Limits m_Limits;
    protected NamedCounter m_Counter;

    public String globalInfo() {
        return "Actor for generating control chart plots.\nThe plot needs to be initialized with a " + ControlChartContainer.class + ". After that, individual numbers or arrays, depending on the control chart algorithm used, can be plotted. The last limits encountered (lower/center/upper) are used for all subsequent values. A vertical indicator is used to separate the data that was used for determining the limits and all subsequent data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("violation-finder", "violationFinder", (Object)new NullViolations());
        this.m_OptionManager.add("paintlet", "paintlet", (Object)new ChartPaintlet());
        this.m_OptionManager.add("limit-paintlet", "limitPaintlet", (Object)new LimitPaintlet());
        this.m_OptionManager.add("separator-paintlet", "separatorPaintlet", (Object)new VerticalMarkers());
        this.m_OptionManager.add("mouse-click-action", "mouseClickAction", (Object)new NullClickAction());
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
        this.m_OptionManager.add("title", "title", (Object)"");
        this.m_OptionManager.add("axis-x", "axisX", (Object)this.getDefaultAxisX());
        this.m_OptionManager.add("axis-y", "axisY", (Object)this.getDefaultAxisY());
        this.m_OptionManager.add("post-processor", "postProcessor", (Object)new PassThrough());
    }

    protected void initialize() {
        super.initialize();
        this.m_Counter = new NamedCounter();
    }

    protected void reset() {
        super.reset();
        this.m_Counter.clear();
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 350;
    }

    public void setViolationFinder(ViolationFinder value) {
        this.m_ViolationFinder = value;
        this.reset();
    }

    public ViolationFinder getViolationFinder() {
        return this.m_ViolationFinder;
    }

    public String violationFinderTipText() {
        return "The algorithm for locating violations.";
    }

    public void setPaintlet(AbstractControlChartPaintlet value) {
        this.m_Paintlet = value;
        this.reset();
    }

    public AbstractControlChartPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "The paintlet to use for painting the data.";
    }

    public void setLimitPaintlet(AbstractControlChartPaintlet value) {
        this.m_LimitPaintlet = value;
        this.reset();
    }

    public AbstractControlChartPaintlet getLimitPaintlet() {
        return this.m_LimitPaintlet;
    }

    public String limitPaintletTipText() {
        return "The paintlet to use for painting the limits.";
    }

    public void setSeparatorPaintlet(MarkerPaintlet value) {
        this.m_SeparatorPaintlet = value;
        this.reset();
    }

    public MarkerPaintlet getSeparatorPaintlet() {
        return this.m_SeparatorPaintlet;
    }

    public String separatorPaintletTipText() {
        return "The paintlet to use for separating data used for initializing the limits and subsequent data.";
    }

    public void setMouseClickAction(MouseClickAction value) {
        this.m_MouseClickAction = value;
        this.reset();
    }

    public MouseClickAction getMouseClickAction() {
        return this.m_MouseClickAction;
    }

    public String mouseClickActionTipText() {
        return "The action to use for mouse clicks on the canvas.";
    }

    public void setColorProvider(AbstractColorProvider value) {
        this.m_ColorProvider = value;
        this.reset();
    }

    public AbstractColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider in use for generating the colors for the various plots.";
    }

    protected AxisPanelOptions getDefaultAxisX() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("sample");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setNthValueToShow(1);
        result.setWidth(40);
        result.setTopMargin(0.05);
        result.setBottomMargin(0.05);
        result.setCustomFormat(new DecimalFormatString("0"));
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(20);
        result.setTickGenerator((TickGenerator)tick);
        return result;
    }

    protected AxisPanelOptions getDefaultAxisY() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("y");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setNthValueToShow(2);
        result.setWidth(60);
        result.setTopMargin(0.05);
        result.setBottomMargin(0.05);
        result.setCustomFormat(new DecimalFormatString("0.0"));
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(10);
        result.setTickGenerator((TickGenerator)tick);
        return result;
    }

    public void setAxisX(AxisPanelOptions value) {
        this.m_AxisX = value;
        this.reset();
    }

    public AxisPanelOptions getAxisX() {
        return this.m_AxisX;
    }

    public String axisXTipText() {
        return "The setup for the X axis.";
    }

    public void setAxisY(AxisPanelOptions value) {
        this.m_AxisY = value;
        this.reset();
    }

    public AxisPanelOptions getAxisY() {
        return this.m_AxisY;
    }

    public String axisYTipText() {
        return "The setup for the Y axis.";
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title for the border around the plot.";
    }

    public void setPostProcessor(AbstractSequencePostProcessor value) {
        this.m_PostProcessor = value;
        this.reset();
    }

    public AbstractSequencePostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public String postProcessorTipText() {
        return "The post-processor to use on the sequences after a token has been added.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"violoationFinder", (Object)this.m_ViolationFinder, (String)"violations: ");
        return result;
    }

    public void clearPanel() {
        if (this.m_Panel != null) {
            ((XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager()).clear();
        }
        this.m_Chart = null;
        this.m_Limits = null;
    }

    protected BasePanel newPanel() {
        MultiPaintlet multi = new MultiPaintlet();
        multi.setSubPaintlets(new XYSequencePaintlet[]{this.getPaintlet(), this.getLimitPaintlet()});
        SequencePlotterPanel result = new SequencePlotterPanel(this.getTitle());
        result.setDataPaintlet((Paintlet)multi);
        result.setMarkerPaintlet((MarkerPaintlet)this.m_SeparatorPaintlet.shallowCopy());
        result.setMouseClickAction(this.m_MouseClickAction);
        this.m_AxisX.configure(result.getPlot(), Axis.BOTTOM);
        this.m_AxisY.configure(result.getPlot(), Axis.LEFT);
        result.setColorProvider(this.getColorProvider().shallowCopy());
        result.getContainerList().setAllowSearch(false);
        ActorUtils.updateFlowAwarePaintlet((Paintlet)result.getDataPaintlet(), (Actor)this);
        ActorUtils.updateFlowAwarePaintlet((Paintlet)result.getMarkerPaintlet(), (Actor)this);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{ControlChartContainer.class, Double.class, Float.class, Integer.class, Double[].class, double[].class, Float[].class, float[].class, Integer[].class, int[].class};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void display(Token token) {
        XYSequenceContainerManager manager = (XYSequenceContainerManager)((SequencePlotterPanel)this.m_Panel).getContainerManager();
        manager.startUpdate();
        if (token.getPayload() instanceof ControlChartContainer) {
            SequencePlotPoint point;
            int x;
            int i;
            XYSequenceContainer cont;
            SequencePlotSequence seq;
            ControlChartContainer chartCont = (ControlChartContainer)((Object)token.getPayload());
            String chartName = (String)chartCont.getValue("Chart");
            double[] prepared = (double[])chartCont.getValue("Prepared");
            Limits[] limits = (Limits[])chartCont.getValue("Limits");
            TIntHashSet violations = new TIntHashSet(this.m_ViolationFinder.find(prepared, limits));
            this.m_Chart = (ControlChart)chartCont.getValue("Algor");
            if (chartName == null) {
                chartName = this.m_Chart.getName();
            }
            this.m_ChartName = chartName;
            this.m_Limits = limits[limits.length - 1];
            if (manager.indexOf(this.m_ChartName) == -1) {
                seq = new SequencePlotSequence();
                seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
                seq.setID(this.m_ChartName);
                cont = manager.newContainer((Comparable)seq);
                manager.add(cont);
            } else {
                cont = (XYSequenceContainer)manager.get(manager.indexOf(this.m_ChartName));
                seq = cont.getData();
            }
            AxisPanel axisX = ((SequencePlotterPanel)this.m_Panel).getPlot().getAxis(Axis.BOTTOM);
            int numTicks = 0;
            for (i = 0; i < manager.countVisible(); ++i) {
                numTicks = Math.max(numTicks, manager.getVisible(i).getData().size());
            }
            TickGenerator tick = axisX.getTickGenerator();
            if (tick instanceof AbstractLimitedTickGenerator && ((AbstractLimitedTickGenerator)tick).getNumTicks() != numTicks) {
                tick = (TickGenerator)tick.shallowCopy();
                ((AbstractLimitedTickGenerator)tick).setNumTicks(numTicks);
                axisX.setTickGenerator(tick);
            }
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (i = 0; i < prepared.length; ++i) {
                HashMap<String, Constable> meta = new HashMap<String, Constable>();
                if (limits.length == prepared.length) {
                    meta.put("lower", Double.valueOf(limits[i].getLower()));
                    meta.put("center", Double.valueOf(limits[i].getCenter()));
                    meta.put("upper", Double.valueOf(limits[i].getUpper()));
                    min = StatUtils.min((double[])new double[]{min, limits[i].getLower(), limits[i].getCenter(), limits[i].getUpper(), prepared[i]});
                    max = StatUtils.max((double[])new double[]{max, limits[i].getLower(), limits[i].getCenter(), limits[i].getUpper(), prepared[i]});
                } else {
                    meta.put("lower", Double.valueOf(limits[0].getLower()));
                    meta.put("center", Double.valueOf(limits[0].getCenter()));
                    meta.put("upper", Double.valueOf(limits[0].getUpper()));
                    min = StatUtils.min((double[])new double[]{min, limits[0].getLower(), limits[0].getCenter(), limits[0].getUpper(), prepared[i]});
                    max = StatUtils.max((double[])new double[]{max, limits[0].getLower(), limits[0].getCenter(), limits[0].getUpper(), prepared[i]});
                }
                meta.put("violation", Boolean.valueOf(violations.contains(i)));
                x = this.m_Counter.next(this.m_ChartName);
                point = new SequencePlotPoint("" + x, (double)x, prepared[i]);
                point.setMetaData(meta);
                seq.add((DataPoint)point);
            }
            XYSequenceContainerManager markerManager = ((SequencePlotterPanel)this.m_Panel).getMarkerContainerManager();
            markerManager.startUpdate();
            if (markerManager.indexOf(this.m_ChartName) == -1) {
                seq = new SequencePlotSequence();
                seq.setComparison(XYSequencePointComparator.Comparison.X_AND_Y);
                seq.setID(this.m_ChartName);
                cont = markerManager.newContainer((Comparable)seq);
                markerManager.add(cont);
            } else {
                cont = (XYSequenceContainer)markerManager.get(manager.indexOf(this.m_ChartName));
                seq = cont.getData();
            }
            x = this.m_Counter.current(this.m_ChartName);
            point = new SequencePlotPoint("" + x, (double)x, 0.0);
            seq.add((DataPoint)point);
            markerManager.finishUpdate();
            AxisPanel axisY = ((SequencePlotterPanel)this.m_Panel).getPlot().getAxis(Axis.LEFT);
            axisY.setManualMinimum(Double.valueOf(min));
            axisY.setManualMaximum(Double.valueOf(max));
            manager.finishUpdate();
            this.m_PostProcessor.postProcess(manager, this.m_ChartName);
        } else if (this.m_Chart instanceof IndividualsControlChart) {
            Compatibility comp = new Compatibility();
            if (!comp.isCompatible(new Class[]{token.getPayload().getClass()}, new Class[]{Double.class, Float.class, Integer.class})) throw new IllegalArgumentException(this.m_Chart.getName() + " cannot process class: " + Utils.classToString(token.getPayload().getClass()));
            TIntHashSet violations = new TIntHashSet(this.m_ViolationFinder.find(new double[]{((Number)token.getPayload()).doubleValue()}, new Limits[]{this.m_Limits}));
            XYSequenceContainer cont = (XYSequenceContainer)manager.get(manager.indexOf(this.m_ChartName));
            XYSequence seq = cont.getData();
            HashMap<String, Constable> meta = new HashMap<String, Constable>();
            meta.put("lower", Double.valueOf(this.m_Limits.getLower()));
            meta.put("center", Double.valueOf(this.m_Limits.getCenter()));
            meta.put("upper", Double.valueOf(this.m_Limits.getUpper()));
            meta.put("violation", Boolean.valueOf(violations.size() > 0));
            double value = ((Number)token.getPayload()).doubleValue();
            double[] prepared = ((IndividualsControlChart)this.m_Chart).prepare(new Double[]{value});
            int x = this.m_Counter.next(this.m_ChartName);
            SequencePlotPoint point = new SequencePlotPoint("" + x, (double)x, prepared[0]);
            point.setMetaData(meta);
            seq.add((DataPoint)point);
            manager.finishUpdate();
            this.m_PostProcessor.postProcess(manager, this.m_ChartName);
        } else {
            int i;
            Number[] numberArray;
            if (!(this.m_Chart instanceof MatrixControlChart)) throw new IllegalArgumentException("Unhandled data: " + Utils.classToString(token.getPayload().getClass()));
            Compatibility comp = new Compatibility();
            if (!comp.isCompatible(new Class[]{token.getPayload().getClass()}, new Class[]{Double[].class, double[].class, Float[].class, float[].class, Integer[].class, int[].class})) throw new IllegalArgumentException(this.m_Chart.getName() + " cannot process class: " + Utils.classToString(token.getPayload().getClass()));
            if (token.getPayload() instanceof Double[]) {
                numberArray = (Double[])token.getPayload();
            } else if (token.getPayload() instanceof double[]) {
                numberArray = StatUtils.toNumberArray((double[])((double[])token.getPayload()));
            } else if (token.getPayload() instanceof Float[]) {
                numberArray = (Float[])token.getPayload();
            } else if (token.getPayload() instanceof float[]) {
                numberArray = StatUtils.toNumberArray((float[])((float[])token.getPayload()));
            } else if (token.getPayload() instanceof Integer[]) {
                numberArray = (Integer[])token.getPayload();
            } else {
                if (!(token.getPayload() instanceof int[])) throw new IllegalStateException("Unhandled token.getPayload() type: " + Utils.classToString(token.getPayload().getClass()));
                numberArray = StatUtils.toNumberArray((int[])((int[])token.getPayload()));
            }
            Limits[] limits = new Limits[numberArray.length];
            for (i = 0; i < limits.length; ++i) {
                limits[i] = this.m_Limits;
            }
            TIntHashSet violations = new TIntHashSet(this.m_ViolationFinder.find(StatUtils.toDoubleArray((Number[])numberArray), limits));
            XYSequenceContainer cont = (XYSequenceContainer)manager.get(manager.indexOf(this.m_ChartName));
            XYSequence seq = cont.getData();
            double[] prepared = ((MatrixControlChart)this.m_Chart).prepare(new Number[][]{numberArray});
            HashMap<String, Constable> meta = new HashMap<String, Constable>();
            meta.put("lower", Double.valueOf(this.m_Limits.getLower()));
            meta.put("center", Double.valueOf(this.m_Limits.getCenter()));
            meta.put("upper", Double.valueOf(this.m_Limits.getUpper()));
            meta.put("violation", Boolean.valueOf(violations.contains(i)));
            int x = this.m_Counter.next(this.m_ChartName);
            SequencePlotPoint point = new SequencePlotPoint("" + x, (double)x, prepared[0]);
            point.setMetaData(meta);
            seq.add((DataPoint)point);
            manager.finishUpdate();
            this.m_PostProcessor.postProcess(manager, this.m_ChartName);
        }
        manager.finishUpdate();
    }
}

