/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.AbstractProbabilityPaintlet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Arrays;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ExponentialDistributionImpl;

public class Exponential
extends AbstractProbabilityPaintlet {
    private static final long serialVersionUID = -3000060668170218515L;

    @Override
    public void configureAxes() {
        this.m_AxisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
        this.m_AxisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
        this.m_AxisBottom.setType(Type.LOG_ABSOLUTE);
        this.m_AxisBottom.setNumberFormat("#.##");
        this.m_AxisLeft.setType(Type.LOG_ABSOLUTE);
        this.m_AxisLeft.setNumberFormat("#.##");
    }

    @Override
    public void calculateDimensions() {
        this.m_Sorted = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_Index);
        this.m_TransformedY = new double[this.m_Sorted.length];
        Arrays.sort(this.m_Sorted);
        for (int i = 0; i < this.m_Sorted.length; ++i) {
            double median = ((double)(i + 1) - 0.3) / ((double)this.m_Sorted.length + 0.4);
            this.m_TransformedY[i] = -1.0 * Math.log10(1.0 - median);
        }
        if (this.m_AxisBottom.getType().canHandle(this.m_Sorted[0], this.m_Sorted[this.m_Sorted.length - 1])) {
            this.m_AxisBottom.setMinimum(this.m_Sorted[0]);
            this.m_AxisBottom.setMaximum(this.m_Sorted[this.m_Sorted.length - 1]);
        } else {
            this.getLogger().severe("errors in plotting");
        }
        if (this.m_AxisLeft.getType().canHandle(this.m_TransformedY[0], this.m_TransformedY[this.m_TransformedY.length - 1])) {
            this.m_AxisLeft.setMinimum(this.m_TransformedY[0]);
            this.m_AxisLeft.setMaximum(this.m_TransformedY[this.m_TransformedY.length - 1]);
        } else {
            this.getLogger().severe("errors in plotting");
        }
        this.m_AxisBottom.setAxisName(this.m_Data.getColumnName(this.m_Index) + ")");
        this.m_AxisLeft.setAxisName("Inverse Exponential");
    }

    public void performPaint(Graphics g, PaintEvent.PaintMoment moment) {
        if (this.m_Data != null && this.m_Sorted != null) {
            GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
            for (int i = 0; i < this.m_Sorted.length; ++i) {
                Graphics2D g2d = (Graphics2D)g;
                if (this.m_Fill) {
                    g2d.setColor(this.m_FillColor);
                    g2d.setStroke(new BasicStroke(0.0f));
                    g2d.fillOval(this.m_AxisBottom.valueToPos(this.m_Sorted[i]) - this.m_Size / 2, this.m_AxisLeft.valueToPos(this.m_TransformedY[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
                }
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
                g2d.setColor(this.m_Color);
                g2d.drawOval(this.m_AxisBottom.valueToPos(this.m_Sorted[i]) - this.m_Size / 2, this.m_AxisLeft.valueToPos(this.m_TransformedY[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
            }
            if (this.m_RegressionLine) {
                g.setColor(Color.BLACK);
                double[] newData = new double[this.m_Sorted.length];
                for (int i = 0; i < this.m_Sorted.length; ++i) {
                    newData[i] = Math.log(this.m_Sorted[i]);
                }
                ExponentialDistributionImpl ex = new ExponentialDistributionImpl(StatUtils.mean((double[])newData));
                for (int i = 0; i < this.m_Sorted.length - 1; ++i) {
                    double prob2;
                    double prob1;
                    try {
                        prob1 = ex.cumulativeProbability(newData[i]);
                    }
                    catch (MathException e) {
                        prob1 = 0.0;
                    }
                    try {
                        prob2 = ex.cumulativeProbability(newData[i + 1]);
                    }
                    catch (MathException e) {
                        prob2 = 0.0;
                    }
                    double p1 = -Math.log(1.0 - prob1);
                    double p2 = -Math.log(1.0 - prob2);
                    g.drawLine(this.m_AxisBottom.valueToPos(this.m_Sorted[i]), this.m_AxisLeft.valueToPos(p1), this.m_AxisBottom.valueToPos(this.m_Sorted[i + 1]), this.m_AxisLeft.valueToPos(p2));
                }
            }
        }
    }

    public String globalInfo() {
        return "Paints the transformed exponential distribution";
    }

    @Override
    public boolean hasFitLine() {
        return false;
    }
}

