/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.zscore;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.axis.Visibility;
import adams.gui.visualization.core.plot.Axis;

public class ZScorePanel
extends PlotPanel {
    private static final long serialVersionUID = -4445527264369086318L;
    protected SpreadSheet m_Data;
    protected int m_Index;

    protected void setData(SpreadSheet inst) {
        this.m_Data = inst;
    }

    protected void initGUI() {
        super.initGUI();
        this.setAxisVisibility(Axis.LEFT, Visibility.VISIBLE);
        this.setAxisVisibility(Axis.BOTTOM, Visibility.VISIBLE);
        this.m_AxisLeft.setNumberFormat("#.##");
        this.m_AxisBottom.setNumberFormat("#");
    }

    public void reset() {
        double[] data = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_Index);
        boolean xMin = false;
        int xMax = data.length;
        double yMin = StatUtils.min((double[])data);
        double yMax = StatUtils.max((double[])data);
        this.m_AxisLeft.setMinimum(yMin);
        this.m_AxisLeft.setMaximum(yMax);
        this.m_AxisBottom.setMinimum((double)xMin);
        this.m_AxisBottom.setMaximum((double)xMax);
        this.m_AxisLeft.setBottomMargin(0.15);
        this.m_AxisLeft.setTopMargin(0.15);
        this.m_AxisLeft.setAxisName(this.m_Data.getColumnName(this.m_Index));
        this.validate();
        this.repaint();
    }

    public void setIndex(int val) {
        this.m_Index = val;
    }

    public AxisPanel getLeft() {
        return this.m_AxisLeft;
    }

    public AxisPanel getBottom() {
        return this.m_AxisBottom;
    }
}

