/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.MatrixPlot;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.paintlet.ScatterPaintletCircle;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.Diagonal;
import adams.test.TmpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class MatrixPlotTest
extends AbstractFlowTest {
    public MatrixPlotTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bodyfat.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bodyfat.csv");
        super.tearDown();
    }

    public Actor getActor() {
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("bodyfat.csv")});
        SpreadSheetFileReader fr = new SpreadSheetFileReader();
        MatrixPlot mp = new MatrixPlot();
        mp.setPlotSize(150);
        mp.setOverlays(new AbstractScatterPlotOverlay[]{new Diagonal()});
        mp.setPaintlet((AbstractScatterPlotPaintlet)new ScatterPaintletCircle());
        Flow flow = new Flow();
        flow.setActors(new Actor[]{sfs, fr, mp});
        return flow;
    }

    public static Test suite() {
        return new TestSuite(MatrixPlotTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MatrixPlotTest.runTest((Test)MatrixPlotTest.suite());
    }
}

