/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.gui.visualization.core.plot.AbstractDistanceBasedHitDetector;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import gnu.trove.list.array.TIntArrayList;
import java.awt.event.MouseEvent;

public abstract class AbstractScatterPlotHitDetector
extends AbstractDistanceBasedHitDetector<int[], String> {
    private static final long serialVersionUID = 8048373104725687691L;
    protected AbstractScatterPlotPaintlet m_Owner;

    public AbstractScatterPlotHitDetector() {
        this(null);
    }

    public AbstractScatterPlotHitDetector(AbstractScatterPlotPaintlet owner) {
        this.setOwner(owner);
    }

    public void setOwner(AbstractScatterPlotPaintlet value) {
        this.m_Owner = value;
    }

    public AbstractScatterPlotPaintlet getOwner() {
        return this.m_Owner;
    }

    protected int[] findClosestXs(double x, double wobble) {
        TIntArrayList result = new TIntArrayList();
        for (int i = 0; i < this.m_Owner.getData().getRowCount(); ++i) {
            double value;
            Cell cell;
            DataRow row = this.m_Owner.getData().getRow(i);
            if (!row.hasCell(this.m_Owner.getXIndex()) || !row.hasCell(this.m_Owner.getYIndex()) || (cell = row.getCell(this.m_Owner.getXIndex())).isMissing() || !cell.isNumeric() || !((value = cell.toDouble().doubleValue()) >= x - wobble) || !(value <= x + wobble)) continue;
            result.add(i);
        }
        return result.toArray();
    }

    protected abstract int[] isHit(MouseEvent var1);

    protected String processHit(MouseEvent e, int[] hit) {
        String result = "";
        for (int i = 0; i < hit.length; ++i) {
            if (i > 0) {
                result = result + ", ";
            }
            result = result + "" + (hit[i] + 1);
        }
        return result;
    }

    public void cleanUp() {
        this.m_Owner = null;
        super.cleanUp();
    }
}

