/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.data.spreadsheet.DataRow;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.sequence.DiameterBasedPaintlet;
import adams.gui.visualization.sequence.MetaXYSequencePaintlet;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotHitDetector;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.paintlet.SizeBasedPaintlet;
import gnu.trove.list.array.TIntArrayList;
import java.awt.event.MouseEvent;

public class ScatterPlotCircleHitDetector
extends AbstractScatterPlotHitDetector {
    private static final long serialVersionUID = -3363546923840405674L;

    public ScatterPlotCircleHitDetector() {
        this(null);
    }

    public ScatterPlotCircleHitDetector(AbstractScatterPlotPaintlet owner) {
        super(owner);
    }

    public String globalInfo() {
        return "Detects circular data points.";
    }

    protected int getDefaultMinimumPixelDifference() {
        return 1;
    }

    @Override
    protected int[] isHit(MouseEvent e) {
        int[] indices;
        if (this.m_Owner == null) {
            return null;
        }
        if (this.m_Owner.getPlot() == null) {
            return null;
        }
        TIntArrayList result = new TIntArrayList();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double y = axisLeft.posToValue(e.getY());
        double x = axisBottom.posToValue(e.getX());
        boolean logging = this.isLoggingEnabled();
        int size = 1;
        if (this.m_Owner instanceof SizeBasedPaintlet) {
            size = ((SizeBasedPaintlet)((Object)this.m_Owner)).getSize();
        } else if (this.m_Owner instanceof MetaXYSequencePaintlet && ((MetaXYSequencePaintlet)this.m_Owner).getPaintlet() instanceof DiameterBasedPaintlet) {
            size = ((DiameterBasedPaintlet)((MetaXYSequencePaintlet)this.m_Owner).getPaintlet()).getDiameter();
        }
        double wobble = Math.abs(axisBottom.posToValue(0) - axisBottom.posToValue(size));
        for (int index : indices = this.findClosestXs(x, wobble)) {
            DataRow row = this.m_Owner.getData().getRow(index);
            double currX = row.getCell(this.m_Owner.getXIndex()).toDouble();
            double currY = row.getCell(this.m_Owner.getYIndex()).toDouble();
            double diffX = currX - x;
            double diffPixel = Math.abs(axisBottom.valueToPos(diffX) - axisBottom.valueToPos(0.0));
            if (logging) {
                this.getLogger().info("diff x=" + diffPixel);
            }
            if (diffPixel > (double)(this.m_MinimumPixelDifference + size / 2)) continue;
            double diffY = currY - y;
            diffPixel = Math.abs(axisLeft.valueToPos(diffY) - axisLeft.valueToPos(0.0));
            if (logging) {
                this.getLogger().info("diff y=" + diffPixel);
            }
            if (diffPixel > (double)(this.m_MinimumPixelDifference + size / 2)) continue;
            if (logging) {
                this.getLogger().info("hit!");
            }
            result.add(index);
        }
        if (result.size() > 0) {
            return result.toArray();
        }
        return null;
    }
}

