/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.scatterplot;

import adams.data.spreadsheet.SpreadSheet;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.plot.HitDetector;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.ScatterPlotPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Date;

public abstract class AbstractScatterPlot
extends PaintablePanel
implements TipTextCustomizer {
    private static final long serialVersionUID = -3526702766287841051L;
    protected ScatterPlotPanel m_Plot;
    protected SpreadSheet m_Data;
    protected int m_XIntIndex;
    protected int m_YIntIndex;
    protected AbstractScatterPlotPaintlet m_Paintlet;
    protected AbstractScatterPlotOverlay[] m_Overlays;

    protected void initialize() {
        super.initialize();
        this.m_XIntIndex = 0;
        this.m_YIntIndex = 0;
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void setPaintlet(AbstractScatterPlotPaintlet val) {
        this.removePaintlet((Paintlet)this.m_Paintlet);
        this.m_Paintlet = val;
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null && this.m_Data != null;
    }

    public void setData(SpreadSheet data) {
        this.m_Data = data;
    }

    public SpreadSheet getData() {
        return this.m_Data;
    }

    public int getXIntIndex() {
        return this.m_XIntIndex;
    }

    public int getYIntIndex() {
        return this.m_YIntIndex;
    }

    public void removeOverlays() {
        if (this.m_Overlays != null) {
            for (int i = 0; i < this.m_Overlays.length; ++i) {
                this.removePaintlet((Paintlet)this.m_Overlays[i].getPaintlet());
            }
            this.m_Overlays = null;
        }
    }

    public void setXIntIndex(int value) {
        this.m_XIntIndex = value;
        this.update();
    }

    public void setYIntIndex(int value) {
        this.m_YIntIndex = value;
        this.update();
    }

    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        String hit;
        String result = tiptext;
        MouseEvent event = new MouseEvent((Component)this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        HitDetector detector = this.m_Paintlet.getHitDetector();
        if (detector != null && (hit = (String)detector.detect(event)) != null) {
            result = result == null ? hit : " (" + hit + ")";
        }
        return result;
    }
}

