/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.scatterplot;

import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.visualization.stats.paintlet.AbstractOverlayPaintlet;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlot;
import java.awt.Color;

public abstract class AbstractScatterPlotOverlay
extends AbstractOptionHandler {
    private static final long serialVersionUID = 7526127735639196077L;
    protected AbstractScatterPlot m_Parent;
    protected SpreadSheet m_Data;
    protected AbstractOverlayPaintlet m_Paintlet;
    protected float m_Thickness;
    protected Color m_Color;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("line-thickness", "thickness", (Object)Float.valueOf(this.getDefaultThickness()), (Number)Float.valueOf(0.0f), null);
        this.m_OptionManager.add("color", "color", (Object)this.getDefaultColor());
    }

    protected float getDefaultThickness() {
        return 2.0f;
    }

    public void setThickness(float value) {
        this.m_Thickness = value;
        this.reset();
    }

    public float getThickness() {
        return this.m_Thickness;
    }

    public String thicknessTipText() {
        return "Thickness of the overlay line";
    }

    protected Color getDefaultColor() {
        return Color.BLUE;
    }

    public void setColor(Color value) {
        this.m_Color = value;
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setColor(value);
        }
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "Color of the overlay line";
    }

    public abstract void setUp();

    protected AbstractScatterPlot getParent() {
        return this.m_Parent;
    }

    public void setParent(AbstractScatterPlot val) {
        this.m_Parent = val;
    }

    public void inst(SpreadSheet inst) {
        this.m_Data = inst;
    }

    public AbstractOverlayPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String name() {
        return this.toString();
    }

    public AbstractScatterPlotOverlay shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractScatterPlotOverlay shallowCopy(boolean expand) {
        return (AbstractScatterPlotOverlay)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }
}

