/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.fourinone;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.fourinone.VersusOrderOptions;
import adams.gui.visualization.stats.fourinone.VersusOrderPanel;
import adams.gui.visualization.stats.paintlet.VsOrderPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class VersusOrder
extends PaintablePanel
implements PopupMenuCustomizer {
    private static final long serialVersionUID = 6182760237927361108L;
    protected SpreadSheet m_Data;
    protected VersusOrderPanel m_Plot;
    protected VsOrderPaintlet m_Val;
    protected VersusOrderOptions m_VsOrderOptions;
    protected int m_Index;
    protected SpreadSheetFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new VersusOrderPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.m_Plot.setPopupMenuCustomizer(this);
        this.add((Component)((Object)this.m_Plot), "Center");
        this.m_Val = new VsOrderPaintlet();
        this.m_Val.setPanel(this);
    }

    public void setOptions(VersusOrderOptions val) {
        this.m_VsOrderOptions = val;
        this.m_VsOrderOptions.getAxisX().configure((PlotPanel)this.m_Plot, Axis.BOTTOM);
        this.m_VsOrderOptions.getAxisY().configure((PlotPanel)this.m_Plot, Axis.LEFT);
        this.removePaintlet((Paintlet)this.m_Val);
        this.m_Val = (VsOrderPaintlet)this.m_VsOrderOptions.getPaintlet().shallowCopy(true);
        this.m_Val.setPanel(this);
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        if (this.m_Data != null) {
            this.m_Val.setData(this.m_Data);
            this.m_Val.setIndex(this.m_Index);
            this.m_Val.setRepaintOnChange(true);
            AxisPanel axisBottom = this.getPlot().getAxis(Axis.BOTTOM);
            AxisPanel axisLeft = this.getPlot().getAxis(Axis.LEFT);
            double[] residuals = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_Index);
            double minY = StatUtils.min((double[])residuals);
            double maxY = StatUtils.max((double[])residuals);
            axisBottom.setMinimum(0.0);
            axisBottom.setMaximum((double)(residuals.length - 1));
            axisLeft.setMinimum(minY);
            axisLeft.setMaximum(maxY);
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null && this.m_Data != null;
    }

    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void setData(SpreadSheet data) {
        this.m_Data = data;
    }

    public void setIndex(int val) {
        this.m_Index = val;
    }

    protected void save() {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(this.m_Data, this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data to file:\n" + this.m_FileChooser.getSelectedFile()));
        }
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        JMenuItem menuitem = new JMenuItem("Save data...", GUIHelper.getEmptyIcon());
        menuitem.addActionListener(ae -> this.save());
        menu.add(menuitem);
    }
}

