/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.utils.LOWESS;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.visualization.stats.paintlet.AbstractOverlayPaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class LowessPaintlet
extends AbstractOverlayPaintlet
implements AntiAliasingSupporter,
TechnicalInformationHandler {
    private static final long serialVersionUID = 1643339689654875242L;
    protected int m_WindowSize;
    protected List<Point2D> m_ToPlot;
    protected boolean m_AntiAliasingEnabled;

    public String globalInfo() {
        return "Paintlet for drawing the lowess overlay.\n\nFor more information see:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("window-size", "windowSize", (Object)100, (Number)1, null);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public TechnicalInformation getTechnicalInformation() {
        return LOWESS.getTechnicalInformation();
    }

    @Override
    public void setWindowSize(int val) {
        this.m_WindowSize = val;
        this.memberChanged();
    }

    public int getWindowSize() {
        return this.m_WindowSize;
    }

    public String windowSizeTipText() {
        return "The window size for smoothing.";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    @Override
    public void calculate() {
        super.calculate();
        double[] x_data = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_XInd);
        double[] y_data = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_YInd);
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        for (int i = 0; i < x_data.length; ++i) {
            Point2D.Double p = new Point2D.Double(x_data[i], y_data[i]);
            points.add(p);
        }
        this.m_ToPlot = LOWESS.calculate(points, (int)this.m_WindowSize);
        this.m_Calculated = true;
    }

    @Override
    protected void drawData(Graphics g) {
        if (this.m_Calculated) {
            GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
            g.setColor(this.m_Color);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            for (int i = 0; i < this.m_ToPlot.size() - 1; ++i) {
                g2d.drawLine(this.m_AxisBottom.valueToPos(this.m_ToPlot.get(i).getX()), this.m_AxisLeft.valueToPos(this.m_ToPlot.get(i).getY()), this.m_AxisBottom.valueToPos(this.m_ToPlot.get(i + 1).getX()), this.m_AxisLeft.valueToPos(this.m_ToPlot.get(i + 1).getY()));
            }
        }
    }
}

