/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.scatterplot;

import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.GenericArrayEditorPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.stats.core.SubSample;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.paintlet.ScatterPaintletCircle;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.Diagonal;
import adams.gui.visualization.stats.scatterplot.ScatterPlotSimple;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Matrix
extends BasePanel {
    private static final long serialVersionUID = -7593836818545034592L;
    private SpreadSheet m_Data;
    private SpreadSheet m_DataOriginal;
    private int m_PlotSize;
    protected JPanel m_Centre;
    protected JSpinner m_Spin;
    protected AbstractScatterPlotOverlay[] m_Default;
    protected GenericArrayEditorPanel m_PanelOverlay;
    protected GenericObjectEditorPanel m_PanelPaintlet;
    protected AbstractScatterPlotPaintlet m_Val;
    protected ArrayList<ScatterPlotSimple> m_ScatterPlots;
    protected ArrayList<AbstractScatterPlotOverlay> m_Array;
    protected HashSet<String> m_OldHash;
    protected AbstractScatterPlotPaintlet m_Def;
    protected ArrayList<JPanel> m_Panels = new ArrayList();
    protected int m_Percent;
    protected JSpinner m_SpinPercent;
    protected HashSet<String> m_DeleteOverlay;
    protected HashSet<String> m_NewOverlay;
    protected JProgressBar m_Bar;
    protected progressWorker m_Work;
    protected JPanel m_Progress;
    protected boolean m_NeedUpdate;
    protected BaseButton m_Stop;
    protected ParameterPanel m_OptionPanel;
    boolean m_IsCancel;

    protected void initialize() {
        super.initialize();
        this.m_PlotSize = 100;
    }

    public void setData(SpreadSheet inst) {
        this.m_DataOriginal = inst;
        this.m_Data = inst;
    }

    public void updateOverlays() {
        this.m_Progress = new JPanel();
        this.add(this.m_Progress, "South");
        this.m_Stop = new BaseButton("Stop");
        this.m_Stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Matrix.this.m_IsCancel = true;
                Matrix.this.m_Work.cancel(true);
            }
        });
        this.m_Progress.add((Component)this.m_Stop, "West");
        this.m_Bar = new JProgressBar(0, 100);
        this.m_Bar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (Matrix.this.m_Bar.getValue() >= 98) {
                    Matrix.this.remove(Matrix.this.m_Progress);
                }
            }
        });
        this.m_Bar.setValue(0);
        this.m_Bar.setStringPainted(true);
        this.m_Progress.add((Component)this.m_Bar, "East");
        this.revalidate();
        this.repaint();
        this.m_OptionPanel.setEnabled(false);
        this.m_Work = new progressWorker();
        this.m_Work.addPropertyChangeListener(new prop());
        this.m_Work.execute();
    }

    private void changeOverlay() {
        if (this.m_OldHash == null) {
            this.m_OldHash = new HashSet();
        }
        int len = ((AbstractScatterPlotOverlay[])this.m_PanelOverlay.getCurrent()).length;
        HashSet<String> m_NewHash = new HashSet<String>();
        for (int i = 0; i < len; ++i) {
            m_NewHash.add(((AbstractScatterPlotOverlay[])this.m_PanelOverlay.getCurrent())[i].toCommandLine());
        }
        this.m_NewOverlay = new HashSet();
        for (String a : m_NewHash) {
            this.m_NewOverlay.add(a);
        }
        this.m_NewOverlay.removeAll(this.m_OldHash);
        HashSet<String> stilOverlay = new HashSet<String>();
        for (String a : this.m_OldHash) {
            stilOverlay.add(a);
        }
        stilOverlay.retainAll(m_NewHash);
        this.m_DeleteOverlay = new HashSet();
        for (String a : this.m_OldHash) {
            this.m_DeleteOverlay.add(a);
        }
        this.m_DeleteOverlay.removeAll(m_NewHash);
        this.repaint();
        this.revalidate();
        this.m_NeedUpdate = true;
    }

    public void redoPaintlets() {
        this.m_Val = (AbstractScatterPlotPaintlet)((Object)this.m_PanelPaintlet.getCurrent());
        String newPaintlet = this.m_Val.toCommandLine();
        for (int j = 0; j < this.m_ScatterPlots.size(); ++j) {
            AbstractScatterPlotPaintlet temp;
            try {
                temp = (AbstractScatterPlotPaintlet)OptionUtils.forCommandLine(AbstractScatterPlotPaintlet.class, (String)newPaintlet);
            }
            catch (Exception e) {
                temp = new ScatterPaintletCircle();
            }
            this.m_ScatterPlots.get(j).setPaintlet(temp);
            temp.setPanel(this.m_ScatterPlots.get(j));
            temp.setXIndex(this.m_ScatterPlots.get((int)j).m_XIntIndex);
            temp.setYIndex(this.m_ScatterPlots.get((int)j).m_YIntIndex);
            temp.setColorIndex(-1);
            temp.setData(this.m_Data);
        }
        this.repaint();
        this.revalidate();
    }

    public void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Default = new AbstractScatterPlotOverlay[0];
        this.m_PanelOverlay = new GenericArrayEditorPanel((Object)this.m_Default);
        this.m_PanelOverlay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Matrix.this.changeOverlay();
            }
        });
        this.m_Def = new ScatterPaintletCircle();
        this.m_PanelPaintlet = new GenericObjectEditorPanel(AbstractScatterPlotPaintlet.class, (Object)this.m_Def, true);
        this.m_PanelPaintlet.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Matrix.this.m_NeedUpdate = true;
            }
        });
        this.m_OptionPanel = new ParameterPanel();
        this.m_Centre = new JPanel(new BorderLayout());
        BaseSplitPane splitPane = new BaseSplitPane(1);
        splitPane.setLeftComponent((Component)this.m_Centre);
        JPanel hold = new JPanel(new BorderLayout());
        hold.add((Component)this.m_OptionPanel, "North");
        splitPane.setRightComponent((Component)hold);
        splitPane.setResizeWeight(1.0);
        splitPane.setOneTouchExpandable(true);
        this.add((Component)splitPane, "Center");
        SpinnerNumberModel spinSize = new SpinnerNumberModel(this.m_PlotSize, 20, 500, 4);
        this.m_Spin = new JSpinner(spinSize);
        this.m_Spin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Matrix.this.m_NeedUpdate = true;
            }
        });
        SpinnerNumberModel percentModel = new SpinnerNumberModel(this.m_Percent, 0, 100, 1);
        this.m_SpinPercent = new JSpinner(percentModel);
        this.m_SpinPercent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Matrix.this.m_NeedUpdate = true;
            }
        });
        BaseButton updateBut = new BaseButton("update");
        updateBut.addActionListener((ActionListener)new action());
        this.m_OptionPanel.addParameter("Overlays", (Component)this.m_PanelOverlay);
        this.m_OptionPanel.addParameter("Paintlet", (Component)this.m_PanelPaintlet);
        this.m_OptionPanel.addParameter("size of each plot", (Component)this.m_Spin);
        this.m_OptionPanel.addParameter("percent of sample", (Component)this.m_SpinPercent);
        this.m_OptionPanel.addParameter("Update matrix", (Component)updateBut);
    }

    private void sample() {
        SubSample subSam = new SubSample(this.m_DataOriginal, this.m_Percent);
        try {
            this.m_Data = subSam.sample();
            this.m_NewOverlay = new HashSet();
            int len = ((AbstractScatterPlotOverlay[])this.m_PanelOverlay.getCurrent()).length;
            for (int i = 0; i < len; ++i) {
                this.m_NewOverlay.add(((AbstractScatterPlotOverlay[])this.m_PanelOverlay.getCurrent())[i].toCommandLine());
            }
            this.m_OldHash = new HashSet();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_ScatterPlots != null) {
            for (ScatterPlotSimple s : this.m_ScatterPlots) {
                s.setData(this.m_Data);
            }
        }
    }

    private void reDisplay() {
        if (this.m_ScatterPlots == null) {
            this.m_Centre.removeAll();
            this.m_Spin.setValue(this.m_PlotSize);
            this.m_SpinPercent.setValue(this.m_Percent);
            this.m_ScatterPlots = new ArrayList();
            Dimension size = new Dimension(this.m_PlotSize, this.m_PlotSize);
            JPanel fullGrid = new JPanel(new GridLayout(this.m_Data.getColumnCount(), 0));
            BaseScrollPane scrollPane = new BaseScrollPane((Component)fullGrid);
            this.m_Centre.add((Component)scrollPane, "Center");
            for (int j = 0; j < this.m_Data.getColumnCount(); ++j) {
                JPanel display = new JPanel();
                display.setBackground(Color.GRAY);
                for (int i = 0; i < this.m_Data.getColumnCount(); ++i) {
                    if (j == i) {
                        JPanel temp = new JPanel(new BorderLayout());
                        temp.setBackground(Color.BLACK);
                        JLabel label = new JLabel(this.m_Data.getColumnName(i));
                        label.setForeground(Color.WHITE);
                        int siz = 22;
                        Font f = new Font("Dialog", 0, siz);
                        label.setFont(f);
                        temp.add((Component)label, "Center");
                        temp.setPreferredSize(size);
                        display.add(temp);
                        this.m_Panels.add(temp);
                        continue;
                    }
                    ScatterPlotSimple scat = new ScatterPlotSimple();
                    scat.setData(this.m_Data);
                    scat.setXIntIndex(i);
                    scat.setYIntIndex(j);
                    scat.setPreferredSize(size);
                    scat.update();
                    display.add((Component)((Object)scat));
                    this.m_ScatterPlots.add(scat);
                }
                fullGrid.add(display);
            }
            this.changeFontSize();
        } else {
            int i;
            Dimension size = new Dimension(this.m_PlotSize, this.m_PlotSize);
            for (i = 0; i < this.m_ScatterPlots.size(); ++i) {
                this.m_ScatterPlots.get(i).setPreferredSize(size);
            }
            for (i = 0; i < this.m_Panels.size(); ++i) {
                this.m_Panels.get(i).setPreferredSize(size);
            }
            this.changeFontSize();
        }
    }

    public void reset() {
        this.sample();
        this.reDisplay();
        this.changeOverlay();
        this.updateOverlays();
        this.redoPaintlets();
        this.repaint();
        this.revalidate();
    }

    private void changeFontSize() {
        JPanel panel;
        int minSize = 32;
        for (int i = 0; i < this.m_Panels.size(); ++i) {
            JLabel temp = (JLabel)this.m_Panels.get(i).getComponent(0);
            panel = this.m_Panels.get(i);
            int siz = 32;
            Font f = new Font("Dialog", 0, siz);
            temp.setFont(f);
            while (temp.getPreferredSize().width > panel.getPreferredSize().width) {
                f = new Font("Dialog", 0, siz -= 2);
                temp.setFont(f);
                if (siz >= minSize) continue;
                minSize = siz;
            }
        }
        Font f = new Font("Dialog", 0, minSize);
        for (int i = 0; i < this.m_Panels.size(); ++i) {
            panel = this.m_Panels.get(i);
            JLabel temp = (JLabel)this.m_Panels.get(i).getComponent(0);
            temp.setFont(f);
            JPanel temp1 = new JPanel();
            temp1.setPreferredSize(new Dimension((panel.getPreferredSize().width - temp.getPreferredSize().width) / 2, 0));
            temp1.setBackground(Color.BLACK);
            panel.add((Component)temp1, "West");
        }
    }

    public void setPaintlet(AbstractScatterPlotPaintlet val) {
        this.m_PanelPaintlet.setCurrent((Object)val.shallowCopy());
    }

    public void setOverlays(AbstractScatterPlotOverlay[] val) {
        AbstractScatterPlotOverlay[] overlays = new AbstractScatterPlotOverlay[val.length];
        for (int i = 0; i < val.length; ++i) {
            overlays[i] = val[i].shallowCopy();
        }
        this.m_PanelOverlay.setCurrent((Object)overlays);
    }

    public void setPlotSize(int val) {
        this.m_PlotSize = val;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void setPercent(int val) {
        this.m_Percent = val;
    }

    class progressWorker
    extends SwingWorker<Void, Void> {
        progressWorker() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            for (int j = 0; j < Matrix.this.m_ScatterPlots.size(); ++j) {
                if (Matrix.this.m_OldHash.size() == 0) {
                    Matrix.this.m_ScatterPlots.get(j).removeAllOverlays();
                } else {
                    Matrix.this.m_ScatterPlots.get(j).removeOverlays(Matrix.this.m_DeleteOverlay);
                }
                for (String str : Matrix.this.m_NewOverlay) {
                    AbstractScatterPlotOverlay temp;
                    try {
                        temp = (AbstractScatterPlotOverlay)OptionUtils.forCommandLine(AbstractScatterPlotOverlay.class, (String)str);
                    }
                    catch (Exception e) {
                        temp = new Diagonal();
                    }
                    temp.inst(Matrix.this.m_Data);
                    temp.setParent(Matrix.this.m_ScatterPlots.get(j));
                    temp.setUp();
                    Matrix.this.m_ScatterPlots.get(j).addOverlay(temp);
                }
                this.setProgress(100 * j / Matrix.this.m_ScatterPlots.size());
            }
            for (int i = 0; i < Matrix.this.m_ScatterPlots.size(); ++i) {
                Matrix.this.m_ScatterPlots.get(i).repaint();
                Matrix.this.m_ScatterPlots.get(i).revalidate();
            }
            return null;
        }

        @Override
        public void done() {
            Matrix.this.m_OptionPanel.setEnabled(true);
            Matrix.this.remove(Matrix.this.m_Progress);
            if (Matrix.this.m_IsCancel) {
                System.out.println("cancelled");
            } else {
                Matrix.this.m_OldHash = new HashSet();
                int len = ((AbstractScatterPlotOverlay[])Matrix.this.m_PanelOverlay.getCurrent()).length;
                for (int i = 0; i < len; ++i) {
                    Matrix.this.m_OldHash.add(((AbstractScatterPlotOverlay[])Matrix.this.m_PanelOverlay.getCurrent())[i].toCommandLine());
                }
                Matrix.this.m_NeedUpdate = false;
                Matrix.this.m_IsCancel = false;
            }
            Matrix.this.m_NewOverlay = new HashSet();
        }
    }

    public class prop
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress" == evt.getPropertyName()) {
                int prog = (Integer)evt.getNewValue();
                Matrix.this.m_Bar.setValue(prog);
                Matrix.this.revalidate();
                Matrix.this.repaint();
            }
        }
    }

    public class action
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (Matrix.this.m_NeedUpdate) {
                if (Matrix.this.m_IsCancel) {
                    Matrix.this.changeOverlay();
                    for (ScatterPlotSimple s : Matrix.this.m_ScatterPlots) {
                        s.removeOverlays(Matrix.this.m_NewOverlay);
                    }
                    Matrix.this.m_IsCancel = false;
                }
                Matrix.this.m_PlotSize = (Integer)Matrix.this.m_Spin.getModel().getValue();
                int temp = (Integer)Matrix.this.m_SpinPercent.getModel().getValue();
                if (temp != Matrix.this.m_Percent) {
                    Matrix.this.m_Percent = temp;
                    Matrix.this.sample();
                }
                Matrix.this.redoPaintlets();
                Matrix.this.reDisplay();
                Matrix.this.repaint();
                Matrix.this.revalidate();
                Matrix.this.updateOverlays();
            }
        }
    }
}

