/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.scatterplot;

import adams.core.Index;
import adams.core.base.BaseRegExp;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.event.PaintListener;
import adams.gui.goe.GenericArrayEditorPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.container.DataHelper;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.core.IndexHelper;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.paintlet.ScatterPaintletCircle;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlot;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.ScatterPlotPanel;
import adams.gui.visualization.stats.scatterplot.action.MouseClickAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class ScatterPlot
extends AbstractScatterPlot
implements PopupMenuCustomizer {
    private static final long serialVersionUID = -7798200657432959204L;
    protected BaseRegExp m_XIndexReg;
    protected Index m_XIndex;
    protected BaseRegExp m_YIndexReg;
    protected Index m_YIndex;
    protected BaseRegExp m_ColorIndexReg;
    protected Index m_ColorIndex;
    protected int m_ColorIntIndex;
    protected BaseComboBox<String> m_ComboBoxY;
    protected BaseComboBox<String> m_ComboBoxX;
    protected BaseComboBox<String> m_ComboBoxColor;
    protected DefaultComboBoxModel<String> m_ModelX;
    protected DefaultComboBoxModel<String> m_ModelY;
    protected DefaultComboBoxModel<String> m_ModelColor;
    protected GenericArrayEditorPanel m_PanelOverlay;
    protected GenericObjectEditorPanel m_PanelPaintlet;
    protected AbstractScatterPlotOverlay[] m_DefaultOverlays;
    protected AbstractScatterPlotPaintlet m_DefaultPaintlet;
    protected MouseClickAction m_MouseClickAction;
    protected SpreadSheetFileChooser m_FileChooser;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_XIntIndex = 0;
        this.m_YIntIndex = 0;
        this.m_ColorIntIndex = -1;
        this.m_XIndexReg = new BaseRegExp("");
        this.m_YIndexReg = new BaseRegExp("");
        this.m_ColorIndexReg = new BaseRegExp("");
        this.m_XIndex = new Index("");
        this.m_YIndex = new Index("");
        this.m_ColorIndex = new Index("");
        this.m_ModelX = new DefaultComboBoxModel();
        this.m_ModelY = new DefaultComboBoxModel();
        this.m_ModelColor = new DefaultComboBoxModel();
        this.m_FileChooser = null;
    }

    @Override
    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void reset() {
        this.m_ModelX.removeAllElements();
        this.m_ModelY.removeAllElements();
        this.m_ModelColor.removeAllElements();
        this.m_ModelColor.addElement("");
        for (int i = 0; i < this.m_Data.getColumnCount(); ++i) {
            this.m_ModelX.addElement(this.m_Data.getColumnName(i));
            this.m_ModelY.addElement(this.m_Data.getColumnName(i));
            this.m_ModelColor.addElement(this.m_Data.getColumnName(i));
        }
        int temp = IndexHelper.getIndex(this.m_XIndexReg, this.m_XIndex, this.m_Data, -1);
        if (temp == -1) {
            temp = 0;
        }
        this.m_XIntIndex = temp;
        temp = IndexHelper.getIndex(this.m_YIndexReg, this.m_YIndex, this.m_Data, -1);
        if (temp == -1) {
            temp = 0;
        }
        this.m_YIntIndex = temp;
        this.m_ColorIntIndex = IndexHelper.getIndex(this.m_ColorIndexReg, this.m_ColorIndex, this.m_Data, -1);
        this.m_ComboBoxY.setSelectedIndex(this.m_YIntIndex);
        this.m_ComboBoxX.setSelectedIndex(this.m_XIntIndex);
        this.m_ComboBoxColor.setSelectedIndex(this.m_ColorIntIndex + 1);
        if (this.m_Overlays == null) {
            this.m_Overlays = new AbstractScatterPlotOverlay[0];
        }
        this.m_Paintlet.setPanel(this);
        this.m_Paintlet.setData(this.m_Data);
        this.change();
    }

    protected void changeOverlay() {
        int i;
        this.removeOverlays();
        int len = ((AbstractScatterPlotOverlay[])this.m_PanelOverlay.getCurrent()).length;
        this.m_Overlays = new AbstractScatterPlotOverlay[len];
        for (i = 0; i < len; ++i) {
            this.m_Overlays[i] = ((AbstractScatterPlotOverlay[])this.m_PanelOverlay.getCurrent())[i].shallowCopy(true);
        }
        for (i = 0; i < this.m_Overlays.length; ++i) {
            AbstractScatterPlotOverlay temp = this.m_Overlays[i];
            temp.inst(this.m_Data);
            temp.setParent(this);
            temp.setUp();
        }
        this.repaint();
    }

    protected void changePaintlet() {
        this.removePaintlet((Paintlet)this.m_Paintlet);
        this.m_Paintlet = (AbstractScatterPlotPaintlet)((Object)this.m_PanelPaintlet.getCurrent());
        this.m_Paintlet.setPanel(this);
        this.m_Paintlet.setYIndex(this.m_YIntIndex);
        this.m_Paintlet.setXIndex(this.m_XIntIndex);
        this.m_Paintlet.setColorIndex(this.m_ColorIntIndex);
        this.m_Paintlet.setData(this.m_Data);
        this.change();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        BaseSplitPane splitPane = new BaseSplitPane(0);
        splitPane.setResizeWeight(0.0);
        splitPane.setOneTouchExpandable(true);
        this.add((Component)splitPane, "Center");
        ParameterPanel optionPanel = new ParameterPanel();
        splitPane.setTopComponent((Component)optionPanel);
        this.m_Plot = new ScatterPlotPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.m_Plot.setTipTextCustomizer(this);
        this.m_Plot.setPopupMenuCustomizer(this);
        this.m_Plot.setBorder(BorderFactory.createLineBorder(Color.black));
        this.m_Plot.addMouseClickListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ScatterPlot.this.m_MouseClickAction != null) {
                    ScatterPlot.this.m_MouseClickAction.mouseClickOccurred(ScatterPlot.this, e);
                }
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)((Object)this.m_Plot), "Center");
        splitPane.setBottomComponent((Component)panel);
        this.m_ComboBoxY = new BaseComboBox(this.m_ModelY);
        this.m_ComboBoxX = new BaseComboBox(this.m_ModelX);
        this.m_ComboBoxColor = new BaseComboBox(this.m_ModelColor);
        AttYListener listenY = new AttYListener(this);
        this.m_ComboBoxY.addItemListener((ItemListener)listenY);
        AttXListener listenX = new AttXListener(this);
        this.m_ComboBoxX.addItemListener((ItemListener)listenX);
        AttColorListener listenColor = new AttColorListener(this);
        this.m_ComboBoxColor.addItemListener((ItemListener)listenColor);
        if (this.m_Paintlet == null) {
            this.m_DefaultPaintlet = new ScatterPaintletCircle();
            this.m_Paintlet = new ScatterPaintletCircle();
        } else {
            this.m_DefaultPaintlet = this.m_Paintlet;
        }
        this.m_PanelPaintlet = new GenericObjectEditorPanel(AbstractScatterPlotPaintlet.class, (Object)this.m_DefaultPaintlet, true);
        this.m_PanelPaintlet.addChangeListener(e -> this.changePaintlet());
        this.m_Overlays = new AbstractScatterPlotOverlay[0];
        this.m_DefaultOverlays = new AbstractScatterPlotOverlay[0];
        this.m_PanelOverlay = new GenericArrayEditorPanel((Object)this.m_DefaultOverlays);
        this.m_PanelOverlay.addChangeListener(e -> this.changeOverlay());
        optionPanel.addParameter("X attribute", this.m_ComboBoxX);
        optionPanel.addParameter("Y attribute", this.m_ComboBoxY);
        optionPanel.addParameter("Color attribute", this.m_ComboBoxColor);
        optionPanel.addParameter("Overlays", (Component)this.m_PanelOverlay);
        optionPanel.addParameter("Paintlet", (Component)this.m_PanelPaintlet);
    }

    public Index getXIndex() {
        return this.m_XIndex;
    }

    public void setXIndex(Index val) {
        this.m_XIndex = val;
    }

    public void setXRegExp(BaseRegExp val) {
        this.m_XIndexReg = val;
    }

    public BaseRegExp getXRegExp() {
        return this.m_XIndexReg;
    }

    public Index getYIndex() {
        return this.m_YIndex;
    }

    public void setYIndex(Index val) {
        this.m_YIndex = val;
    }

    public void setYRegExp(BaseRegExp val) {
        this.m_YIndexReg = val;
    }

    public BaseRegExp getYRegExp() {
        return this.m_YIndexReg;
    }

    public Index getColorIndex() {
        return this.m_ColorIndex;
    }

    public void setColorIndex(Index val) {
        this.m_ColorIndex = val;
    }

    public void setColorRegExp(BaseRegExp val) {
        this.m_ColorIndexReg = val;
    }

    public BaseRegExp getColorRegExp() {
        return this.m_ColorIndexReg;
    }

    public void setOverlays(AbstractScatterPlotOverlay[] val) {
        AbstractScatterPlotOverlay[] overlays = new AbstractScatterPlotOverlay[val.length];
        for (int i = 0; i < val.length; ++i) {
            overlays[i] = val[i].shallowCopy();
        }
        this.m_PanelOverlay.setCurrent((Object)overlays);
        this.changeOverlay();
    }

    public AbstractScatterPlotOverlay[] getOverlays() {
        return this.m_Overlays;
    }

    public AbstractScatterPlotPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    @Override
    public void setPaintlet(AbstractScatterPlotPaintlet val) {
        this.m_PanelPaintlet.setCurrent((Object)val.shallowCopy());
        this.changePaintlet();
    }

    public void change() {
        if (this.m_Data != null) {
            this.m_Plot.setData(this.m_Data);
        }
        this.m_Plot.setXIndex(this.m_XIntIndex);
        this.m_Plot.setYIndex(this.m_YIntIndex);
        this.m_Plot.reset();
        this.m_Paintlet.setXIndex(this.m_XIntIndex);
        this.m_Paintlet.setYIndex(this.m_YIntIndex);
        this.m_Paintlet.setColorIndex(this.m_ColorIntIndex);
        this.m_Paintlet.setData(this.m_Data);
        this.update();
    }

    public void prepareUpdate() {
        for (int i = 0; i < this.m_Overlays.length; ++i) {
            if (this.m_Overlays[i].getPaintlet() == null) continue;
            this.m_Overlays[i].getPaintlet().parameters(this.m_Data, this.m_XIntIndex, this.m_YIntIndex);
            if (this.m_Overlays[i].getPaintlet().getCalculated()) continue;
            this.m_Overlays[i].getPaintlet().calculate();
        }
    }

    public void setMouseClickAction(MouseClickAction value) {
        this.m_MouseClickAction = value;
    }

    public MouseClickAction getMouseClickAction() {
        return this.m_MouseClickAction;
    }

    protected void save(double[] xRange, double[] yRange) {
        int retVal;
        SpreadSheet data = this.m_Data;
        if (xRange != null && yRange != null) {
            data = DataHelper.filter((SpreadSheet)data, (String)("" + (String)this.m_ComboBoxX.getSelectedItem()), (double[])xRange, (String)("" + (String)this.m_ComboBoxY.getSelectedItem()), (double[])yRange);
        }
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(data, this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data to file:\n" + this.m_FileChooser.getSelectedFile()));
        }
    }

    protected void save() {
        this.save(null, null);
    }

    protected void saveVisible() {
        this.save(new double[]{this.m_Plot.getAxis(Axis.BOTTOM).getActualMinimum(), this.m_Plot.getAxis(Axis.BOTTOM).getActualMaximum()}, new double[]{this.m_Plot.getAxis(Axis.LEFT).getActualMinimum(), this.m_Plot.getAxis(Axis.LEFT).getActualMaximum()});
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        JMenuItem menuitem = new JMenuItem("Save data...", GUIHelper.getEmptyIcon());
        menuitem.addActionListener(ae -> this.save());
        menu.add(menuitem);
        menuitem = new JMenuItem("Save visible data...", GUIHelper.getEmptyIcon());
        menuitem.addActionListener(ae -> this.saveVisible());
        menu.add(menuitem);
    }

    protected class AttColorListener
    implements ItemListener {
        protected ScatterPlot m_parent;

        public AttColorListener(ScatterPlot parent) {
            this.m_parent = parent;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SpreadSheet data = this.m_parent.getData();
            if (e.getStateChange() == 1) {
                ScatterPlot.this.m_ColorIntIndex = -1;
                String chose = (String)e.getItem();
                for (int t = 0; t < data.getColumnCount(); ++t) {
                    if (!data.getColumnName(t).equals(chose)) continue;
                    for (int i = 0; i < ScatterPlot.this.m_Overlays.length; ++i) {
                        ScatterPlot.this.m_Overlays[i].getPaintlet().setCalculated(false);
                    }
                    ScatterPlot.this.m_ColorIntIndex = t;
                    break;
                }
                ScatterPlot.this.change();
            }
        }
    }

    protected class AttXListener
    implements ItemListener {
        protected ScatterPlot m_parent;

        public AttXListener(ScatterPlot parent) {
            this.m_parent = parent;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SpreadSheet data = this.m_parent.getData();
            if (e.getStateChange() == 1) {
                String chose = (String)e.getItem();
                for (int t = 0; t < data.getColumnCount(); ++t) {
                    if (!data.getColumnName(t).equals(chose)) continue;
                    for (int i = 0; i < ScatterPlot.this.m_Overlays.length; ++i) {
                        ScatterPlot.this.m_Overlays[i].getPaintlet().setCalculated(false);
                    }
                    ScatterPlot.this.m_XIntIndex = t;
                    ScatterPlot.this.change();
                    break;
                }
            }
        }
    }

    protected class AttYListener
    implements ItemListener {
        protected ScatterPlot m_parent;

        public AttYListener(ScatterPlot parent) {
            this.m_parent = parent;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            SpreadSheet data = this.m_parent.getData();
            if (e.getStateChange() == 1) {
                String chose = (String)e.getItem();
                for (int t = 0; t < data.getColumnCount(); ++t) {
                    if (!data.getColumnName(t).equals(chose)) continue;
                    for (int i = 0; i < ScatterPlot.this.m_Overlays.length; ++i) {
                        ScatterPlot.this.m_Overlays[i].getPaintlet().setCalculated(false);
                    }
                    ScatterPlot.this.m_YIntIndex = t;
                    ScatterPlot.this.change();
                    break;
                }
            }
        }
    }
}

