/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.scatterplot.action;

import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotHitDetector;
import adams.gui.visualization.stats.paintlet.ScatterPlotCircleHitDetector;
import adams.gui.visualization.stats.scatterplot.ScatterPlot;
import adams.gui.visualization.stats.scatterplot.action.AbstractMouseClickAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.MouseEvent;

public class ViewDataClickAction
extends AbstractMouseClickAction {
    private static final long serialVersionUID = -1383042782074675611L;
    protected AbstractScatterPlotHitDetector m_HitDetector;

    public String globalInfo() {
        return "Displays the data that the user clicked on.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("hit-detector", "hitDetector", (Object)new ScatterPlotCircleHitDetector());
    }

    public void setHitDetector(AbstractScatterPlotHitDetector value) {
        this.m_HitDetector = value;
        this.reset();
    }

    public AbstractScatterPlotHitDetector getHitDetector() {
        return this.m_HitDetector;
    }

    public String hitDetectorTipText() {
        return "The hit detector to use.";
    }

    @Override
    protected void processLeftClick(ScatterPlot panel, MouseEvent e) {
        Object located;
        if (this.m_HitDetector.getOwner() != panel.getPaintlet()) {
            this.m_HitDetector.setOwner(panel.getPaintlet());
        }
        if ((located = this.m_HitDetector.locate(e)) instanceof int[]) {
            int[] hits = (int[])located;
            SpreadSheet sheet = this.m_HitDetector.getOwner().getData().getHeader();
            for (int hit : hits) {
                sheet.addRow().assign((Row)this.m_HitDetector.getOwner().getData().getRow(hit));
            }
            if (sheet.getRowCount() > 0) {
                SpreadSheetDialog dialog = panel.getParentDialog() != null ? new SpreadSheetDialog(panel.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(panel.getParentFrame(), false);
                dialog.setDefaultCloseOperation(2);
                dialog.setTitle("Data");
                dialog.setSize(GUIHelper.getDefaultDialogDimension());
                dialog.setLocationRelativeTo((Component)((Object)panel));
                dialog.setSpreadSheet(sheet);
                dialog.setVisible(true);
            }
        }
    }

    @Override
    protected void processRightClick(ScatterPlot panel, MouseEvent e) {
    }
}

