/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.visualization.stats.paintlet.AbstractZOverlayPaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class MeanPaintlet
extends AbstractZOverlayPaintlet {
    private static final long serialVersionUID = 5598800448367472406L;
    protected double m_Mean;

    @Override
    protected void drawData(Graphics g) {
        if (this.m_Calculated) {
            g.setColor(this.m_Color);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            g2d.drawLine(0, this.m_AxisLeft.valueToPos(this.m_Mean), this.m_AxisBottom.valueToPos(this.m_AxisBottom.getMaximum()), this.m_AxisLeft.valueToPos(this.m_Mean));
        }
    }

    public String globalInfo() {
        return "paintlet for displaying mean overlay on the ZScore graph ";
    }

    @Override
    public void setStd(double val) {
    }

    @Override
    public void calculate() {
        super.calculate();
        double[] data = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_Ind);
        this.m_Mean = StatUtils.mean((double[])data);
        this.m_Calculated = true;
    }
}

