/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.zscore;

import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.visualization.stats.paintlet.AbstractZOverlayPaintlet;
import adams.gui.visualization.stats.zscore.ZScore;
import java.awt.Color;

public abstract class AbstractZScoreOverlay
extends AbstractOptionHandler {
    private static final long serialVersionUID = -1577548974132918070L;
    protected ZScore m_Parent;
    protected SpreadSheet m_Data;
    protected AbstractZOverlayPaintlet m_Paintlet;
    protected Color m_Color;
    protected float m_Thickness;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)Color.BLACK);
        this.m_OptionManager.add("line-thickness", "thickness", (Object)Float.valueOf(2.0f), (Number)Float.valueOf(1.0f), (Number)Float.valueOf(5.0f));
    }

    public void setThickness(float val) {
        this.m_Thickness = val;
        this.reset();
    }

    public float getThickness() {
        return this.m_Thickness;
    }

    public String thicknessTipText() {
        return "Thickness of the overlay line";
    }

    public abstract void setUp();

    protected ZScore getParent() {
        return this.m_Parent;
    }

    public void setParent(ZScore val) {
        this.m_Parent = val;
    }

    public void setData(SpreadSheet value) {
        this.m_Data = value;
    }

    public AbstractZOverlayPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public AbstractZScoreOverlay shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractZScoreOverlay shallowCopy(boolean expand) {
        return (AbstractZScoreOverlay)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public abstract String shortName();

    public void setColor(Color val) {
        this.m_Color = val;
        if (this.m_Paintlet != null) {
            this.m_Paintlet.setColor(val);
        }
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "Colour to draw the overlay";
    }
}

