/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spc;

import adams.core.License;
import adams.core.TechnicalInformation;
import adams.core.annotation.MixedCopyright;
import adams.data.spc.AbstractControlChart;
import adams.data.spc.IndividualsControlChart;
import adams.data.spc.Limits;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;

@MixedCopyright(author="Manuel Baena (mbaena@lcc.uma.es)", copyright="2014 - 2015 Apache Software Foundation", url="https://github.com/apache/incubator-samoa/blob/9b178f63152e5b4c262e0f3ed28e77667832fc98/samoa-api/src/main/java/org/apache/samoa/moa/classifiers/core/driftdetection/PageHinkleyDM.java", license=License.APACHE2)
public class MOAPageHinkley
extends AbstractControlChart
implements IndividualsControlChart {
    private static final long serialVersionUID = -8104165645635976186L;
    protected int m_MinNumValues;
    protected double m_Delta;
    protected double m_Lambda;
    protected double m_Alpha;

    public String globalInfo() {
        return "Page-Hinkley Test.\n\nThis version is based on MOA's drift detector:\nhttps://github.com/apache/incubator-samoa/blob/9b178f63152e5b4c262e0f3ed28e77667832fc98/samoa-api/src/main/java/org/apache/samoa/moa/classifiers/core/driftdetection/PageHinkleyDM.java";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "E. S. Page");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Biometrika");
        result.setValue(TechnicalInformation.Field.VOLUME, "41 (1/2)");
        result.setValue(TechnicalInformation.Field.YEAR, "1954");
        result.setValue(TechnicalInformation.Field.PAGES, "100-115");
        result.setValue(TechnicalInformation.Field.TITLE, "Continuous inspection schemes");
        result.setValue(TechnicalInformation.Field.URL, "http://www.jstor.org/stable/2333009");
        return result;
    }

    @Override
    public String getName() {
        return "MOA-PageHinkley";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-num-values", "minNumValues", (Object)30, (Number)1, null);
        this.m_OptionManager.add("delta", "delta", (Object)0.05, (Number)0.0, null);
        this.m_OptionManager.add("lambda", "lambda", (Object)4.0, (Number)0.0, null);
        this.m_OptionManager.add("alpha", "alpha", (Object)0.99, (Number)0.0, (Number)1.0);
    }

    public void setMinNumValues(int value) {
        if (this.getOptionManager().isValid("minNumValues", (Number)value)) {
            this.m_MinNumValues = value;
            this.reset();
        }
    }

    public int getMinNumValues() {
        return this.m_MinNumValues;
    }

    public String minNumValuesTipText() {
        return "The minimum number of values to process before testing.";
    }

    public void setDelta(double value) {
        if (this.getOptionManager().isValid("delta", (Number)value)) {
            this.m_Delta = value;
            this.reset();
        }
    }

    public double getDelta() {
        return this.m_Delta;
    }

    public String deltaTipText() {
        return "The delta parameter.";
    }

    public void setLambda(double value) {
        if (this.getOptionManager().isValid("lambda", (Number)value)) {
            this.m_Lambda = value;
            this.reset();
        }
    }

    public double getLambda() {
        return this.m_Lambda;
    }

    public String lambdaTipText() {
        return "The threshold for the test.";
    }

    public void setAlpha(double value) {
        if (this.getOptionManager().isValid("alpha", (Number)value)) {
            this.m_Alpha = value;
            this.reset();
        }
    }

    public double getAlpha() {
        return this.m_Alpha;
    }

    public String alphaTipText() {
        return "The alpha parameter for the test.";
    }

    @Override
    public List<Limits> calculate(Number[] data) {
        ArrayList<Limits> result = new ArrayList<Limits>();
        for (int i = 0; i < data.length; ++i) {
            result.add(new Limits(-this.m_Lambda, 0.0, this.m_Lambda));
        }
        return result;
    }

    @Override
    public double[] prepare(Number[] data) {
        TDoubleArrayList result = new TDoubleArrayList();
        double x_mean = 0.0;
        double sum = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double x = data[i].doubleValue();
            x_mean += (x - x_mean) / ((double)i + 1.0);
            sum = this.m_Alpha * sum + (x - x_mean - this.m_Delta);
            if (i + 1 < this.m_MinNumValues) continue;
            result.add(sum);
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info(i + 1 + ". x=" + x + ", sum=" + sum);
        }
        return result.toArray();
    }
}

