/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.data.spc.ControlChart;
import adams.data.spc.Limits;
import adams.flow.container.AbstractContainer;
import java.util.ArrayList;
import java.util.Iterator;

public class ControlChartContainer
extends AbstractContainer {
    private static final long serialVersionUID = 1960872156580346093L;
    public static final String VALUE_ALGORITHM = "Algor";
    public static final String VALUE_CHART = "Chart";
    public static final String VALUE_DATA = "Data";
    public static final String VALUE_PREPARED = "Prepared";
    public static final String VALUE_LIMITS = "Limits";

    public ControlChartContainer() {
        this(null, null, new double[0], new double[0], new Limits[]{new Limits()});
    }

    public ControlChartContainer(ControlChart algorithm, String chart, Object data, Object prepared, Limits[] limits) {
        if (limits.length < 1) {
            throw new IllegalArgumentException("At least one Limit container has to be provided!");
        }
        if (chart != null && chart.isEmpty()) {
            chart = null;
        }
        this.store(VALUE_ALGORITHM, algorithm);
        this.store(VALUE_CHART, chart);
        this.store(VALUE_DATA, data);
        this.store(VALUE_PREPARED, prepared);
        this.store(VALUE_LIMITS, limits);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_ALGORITHM, "control chart algorithm", ControlChart.class);
        this.addHelp(VALUE_CHART, "name of the chart", String.class);
        this.addHelp(VALUE_DATA, "original data", Object.class);
        this.addHelp(VALUE_PREPARED, "prepared/processed data", Object.class);
        this.addHelp(VALUE_LIMITS, "limits; ", Limits[].class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_ALGORITHM);
        result.add(VALUE_CHART);
        result.add(VALUE_DATA);
        result.add(VALUE_PREPARED);
        result.add(VALUE_LIMITS);
        return result.iterator();
    }

    public boolean isValid() {
        return this.hasValue(VALUE_ALGORITHM) && this.hasValue(VALUE_DATA) && this.hasValue(VALUE_PREPARED) && this.hasValue(VALUE_LIMITS);
    }
}

