/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Index;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.stats.fourinone.FourInOne;
import adams.gui.visualization.stats.fourinone.VersusFitOptions;
import adams.gui.visualization.stats.fourinone.VersusOrderOptions;
import adams.gui.visualization.stats.histogram.HistogramOptions;
import adams.gui.visualization.stats.probabilityplot.NormalPlotOptions;
import java.awt.Component;
import javax.swing.JComponent;

public class FourInOneDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -5847391335658516849L;
    protected FourInOne m_Plot;
    protected NormalPlotOptions m_NormalPlotOptions;
    protected HistogramOptions m_HistogramOptions;
    protected VersusFitOptions m_VersusFitOptions;
    protected VersusOrderOptions m_VersusOrderOptions;
    protected String m_Act;
    protected String m_pred;

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actual-attribute", "actualAttribute", (Object)"1");
        this.m_OptionManager.add("predicted-attribute", "predictedAttribute", (Object)"2");
        this.m_OptionManager.add("normal-plot-options", "normalPlotOptions", (Object)new NormalPlotOptions());
        this.m_OptionManager.add("versus-fit-options", "versusFitOptions", (Object)new VersusFitOptions());
        this.m_OptionManager.add("histogram-options", "histogramOptions", (Object)new HistogramOptions());
        this.m_OptionManager.add("versus-order-options", "versusOrderOptions", (Object)new VersusOrderOptions());
    }

    public void setActualAttribute(String val) {
        this.m_Act = val;
        this.reset();
    }

    public String getActualAttribute() {
        return this.m_Act;
    }

    public String actualAttributeTipText() {
        return "1-based index of the actual attribute";
    }

    public void setPredictedAttribute(String val) {
        this.m_pred = val;
        this.reset();
    }

    public String getPredictedAttribute() {
        return this.m_pred;
    }

    public String predictedAttributeTipText() {
        return "1-based index of the predicted attribute";
    }

    public void setHistogramOptions(HistogramOptions val) {
        this.m_HistogramOptions = val;
        this.reset();
    }

    public HistogramOptions getHistogramOptions() {
        return this.m_HistogramOptions;
    }

    public String histogramOptionsTipText() {
        return "options for the histogram graph";
    }

    public void setVersusOrderOptions(VersusOrderOptions val) {
        this.m_VersusOrderOptions = val;
        this.reset();
    }

    public VersusOrderOptions getVersusOrderOptions() {
        return this.m_VersusOrderOptions;
    }

    public String versusOrderOptionsTipText() {
        return "options for the versus order graph";
    }

    public void setVersusFitOptions(VersusFitOptions val) {
        this.m_VersusFitOptions = val;
        this.reset();
    }

    public VersusFitOptions getVersusFitOptions() {
        return this.m_VersusFitOptions;
    }

    public String versusFitOptionsTipText() {
        return "options for the versus fit graph";
    }

    public void setNormalPlotOptions(NormalPlotOptions val) {
        this.m_NormalPlotOptions = val;
        this.reset();
    }

    public NormalPlotOptions getNormalPlotOptions() {
        return this.m_NormalPlotOptions;
    }

    public String normalPlotOptionsTipText() {
        return "options for normal plot";
    }

    public void clearPanel() {
        if (this.m_Plot != null) {
            DefaultSpreadSheet temp = new DefaultSpreadSheet();
            this.m_Plot.setData((SpreadSheet)temp);
        }
    }

    protected BasePanel newPanel() {
        this.m_Plot = new FourInOne();
        return this.m_Plot;
    }

    protected void display(Token token) {
        this.m_Plot.setData((SpreadSheet)token.getPayload());
        this.m_Plot.setAct(new Index(this.m_Act));
        this.m_Plot.setPred(new Index(this.m_pred));
        this.m_Plot.setOptions(this.m_HistogramOptions, this.m_VersusFitOptions, this.m_VersusOrderOptions, this.m_NormalPlotOptions);
        this.m_Plot.reset();
    }

    protected int getDefaultWidth() {
        return 1200;
    }

    protected int getDefaultHeight() {
        return 750;
    }

    public String globalInfo() {
        return "Actor for displaying a four-in-one plot. Contains a histogram, a normal probability plot, vs fit plot and vs order plot";
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel("4-in-1 plot"){
            private static final long serialVersionUID = 4360182045245637304L;
            protected FourInOne m_Plot;

            protected void initGUI() {
                super.initGUI();
                this.m_Plot = new FourInOne();
                this.add((Component)((Object)this.m_Plot), "Center");
            }

            public void display(Token token) {
                this.m_Plot.setData((SpreadSheet)token.getPayload());
                this.m_Plot.setAct(new Index(FourInOneDisplay.this.m_Act));
                this.m_Plot.setPred(new Index(FourInOneDisplay.this.m_pred));
                this.m_Plot.setOptions(FourInOneDisplay.this.m_HistogramOptions, FourInOneDisplay.this.m_VersusFitOptions, FourInOneDisplay.this.m_VersusOrderOptions, FourInOneDisplay.this.m_NormalPlotOptions);
                this.m_Plot.reset();
            }

            public void clearPanel() {
                DefaultSpreadSheet temp = new DefaultSpreadSheet();
                this.m_Plot.setData((SpreadSheet)temp);
            }

            public JComponent supplyComponent() {
                return this.m_Plot;
            }

            public void cleanUp() {
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

