/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Index;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextAndComponentDisplayPanel;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.visualization.stats.histogram.HistogramOptions;
import java.awt.Component;
import javax.swing.JComponent;

public class Histogram
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier,
SpreadSheetSupporter {
    private static final long serialVersionUID = 8145699633341614296L;
    protected Index m_Index;
    protected String m_DataName;
    protected HistogramOptions m_Options;

    public String globalInfo() {
        return "Generates a histogram based on the incoming data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("index", "index", (Object)new Index("first"));
        this.m_OptionManager.add("data-name", "dataName", (Object)"");
        this.m_OptionManager.add("options", "options", (Object)new HistogramOptions());
    }

    public void setIndex(Index value) {
        this.m_Index = value;
        this.reset();
    }

    public Index getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The attribute index in case of spreadsheet being displayed.";
    }

    public void setDataName(String value) {
        this.m_DataName = value;
        this.reset();
    }

    public String getDataName() {
        return this.m_DataName;
    }

    public String dataNameTipText() {
        return "The name to display on the x-axis, overrides the attribute name obtained from the Instances.";
    }

    public void setOptions(HistogramOptions value) {
        this.m_Options = value;
        this.reset();
    }

    public HistogramOptions getOptions() {
        return this.m_Options;
    }

    public String optionsTipText() {
        return "The display options for the histogram.";
    }

    public Class[] accepts() {
        return new Class[]{Double[].class, SpreadSheet.class};
    }

    protected void display(Token token) {
        adams.gui.visualization.stats.histogram.Histogram hist = (adams.gui.visualization.stats.histogram.Histogram)this.m_Panel;
        if (token.getPayload() instanceof SpreadSheet) {
            SpreadSheet data = (SpreadSheet)token.getPayload();
            this.m_Index.setMax(data.getColumnCount());
            hist.setIndex(this.m_Index.getIntIndex());
            hist.setData(data);
        } else {
            hist.setArray((Double[])token.getPayload());
        }
        hist.setDataName(this.m_DataName);
        hist.update();
    }

    public void clearPanel() {
        if (this.m_Panel != null) {
            adams.gui.visualization.stats.histogram.Histogram hist = (adams.gui.visualization.stats.histogram.Histogram)this.m_Panel;
            hist.setData(null);
            hist.setArray(null);
            hist.update();
        }
    }

    protected BasePanel newPanel() {
        adams.gui.visualization.stats.histogram.Histogram result = new adams.gui.visualization.stats.histogram.Histogram();
        result.setOptions(this.m_Options);
        return result;
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractTextAndComponentDisplayPanel result = new AbstractTextAndComponentDisplayPanel("Histogram"){
            private static final long serialVersionUID = 4360182045245637304L;
            protected adams.gui.visualization.stats.histogram.Histogram m_Histogram;

            protected void initGUI() {
                super.initGUI();
                this.m_Histogram = new adams.gui.visualization.stats.histogram.Histogram();
                this.m_Histogram.setOptions(Histogram.this.m_Options);
                this.add((Component)((Object)this.m_Histogram), "Center");
            }

            public void display(Token token) {
                if (token.getPayload() instanceof SpreadSheet) {
                    SpreadSheet data = (SpreadSheet)token.getPayload();
                    Histogram.this.m_Index.setMax(data.getColumnCount());
                    this.m_Histogram.setData(data);
                    this.m_Histogram.setIndex(Histogram.this.m_Index.getIntIndex());
                } else {
                    this.m_Histogram.setArray((Double[])token.getPayload());
                }
                this.m_Histogram.setDataName(Histogram.this.m_DataName);
                this.m_Histogram.update();
            }

            public void clearPanel() {
                this.m_Histogram.setData(null);
                this.m_Histogram.setArray(null);
                this.m_Histogram.update();
            }

            public JComponent supplyComponent() {
                return this.m_Histogram;
            }

            public String getCustomSupplyTextMenuItemCaption() {
                return ((adams.gui.visualization.stats.histogram.Histogram)Histogram.this.m_Panel).getCustomSupplyTextMenuItemCaption();
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return ((adams.gui.visualization.stats.histogram.Histogram)Histogram.this.m_Panel).getCustomTextFileFilter();
            }

            public String supplyText() {
                return ((adams.gui.visualization.stats.histogram.Histogram)Histogram.this.m_Panel).supplyText();
            }

            public void cleanUp() {
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public SpreadSheet toSpreadSheet() {
        if (this.m_Panel == null) {
            return null;
        }
        return ((adams.gui.visualization.stats.histogram.Histogram)this.m_Panel).toSpreadSheet();
    }

    public String getCustomSupplyTextMenuItemCaption() {
        if (this.m_Panel == null) {
            return "Save histogram as...";
        }
        return ((adams.gui.visualization.stats.histogram.Histogram)this.m_Panel).getCustomSupplyTextMenuItemCaption();
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        if (this.m_Panel == null) {
            return new ExtensionFileFilter("CSV files", "csv");
        }
        return ((adams.gui.visualization.stats.histogram.Histogram)this.m_Panel).getCustomTextFileFilter();
    }

    public String supplyText() {
        if (this.m_Panel == null) {
            return null;
        }
        return ((adams.gui.visualization.stats.histogram.Histogram)this.m_Panel).supplyText();
    }
}

