/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.Index;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextAndComponentDisplayPanel;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import adams.gui.visualization.stats.paintlet.ScatterPaintletCircle;
import adams.gui.visualization.stats.scatterplot.AbstractScatterPlotOverlay;
import adams.gui.visualization.stats.scatterplot.ScatterPlot;
import adams.gui.visualization.stats.scatterplot.action.MouseClickAction;
import adams.gui.visualization.stats.scatterplot.action.NullClickAction;
import java.awt.Component;
import javax.swing.JComponent;

public class ScatterDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier,
SpreadSheetSupporter {
    private static final long serialVersionUID = -1985415728904099274L;
    protected BaseRegExp m_XAttributeName;
    protected BaseRegExp m_YAttributeName;
    protected BaseRegExp m_ColorAttributeName;
    protected String m_XAttribute;
    protected String m_YAttribute;
    protected String m_ColorAttribute;
    protected ScatterPlot m_ScatterPlot;
    protected AbstractScatterPlotOverlay[] m_Overlays;
    protected AbstractScatterPlotPaintlet m_Paintlet;
    protected MouseClickAction m_MouseClickAction;

    public String globalInfo() {
        return "Actor for displaying a scatter plot of one attribute vs another.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x-attribute-name", "xAttributeName", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("y-attribute-name", "yAttributeName", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("color-attribute-name", "colorAttributeName", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("x-attribute", "xAttribute", (Object)"1");
        this.m_OptionManager.add("y-attribute", "yAttribute", (Object)"1");
        this.m_OptionManager.add("color-attribute", "colorAttribute", (Object)"");
        this.m_OptionManager.add("overlay", "overlays", (Object)new AbstractScatterPlotOverlay[0]);
        this.m_OptionManager.add("paintlet", "paintlet", (Object)new ScatterPaintletCircle());
        this.m_OptionManager.add("mouse-click-action", "mouseClickAction", (Object)new NullClickAction());
    }

    protected int getDefaultWidth() {
        return 800;
    }

    protected int getDefaultHeight() {
        return 600;
    }

    public void setOverlays(AbstractScatterPlotOverlay[] over) {
        this.m_Overlays = over;
        this.reset();
    }

    public AbstractScatterPlotOverlay[] getOverlays() {
        return this.m_Overlays;
    }

    public String overlaysTipText() {
        return "add overlays to the scatterplot";
    }

    public void setPaintlet(AbstractScatterPlotPaintlet pain) {
        this.m_Paintlet = pain;
        this.reset();
    }

    public AbstractScatterPlotPaintlet getPaintlet() {
        return this.m_Paintlet;
    }

    public String paintletTipText() {
        return "Paintlet for plotting data";
    }

    public void setXAttributeName(BaseRegExp val) {
        this.m_XAttributeName = val;
        this.reset();
    }

    public BaseRegExp getXAttributeName() {
        return this.m_XAttributeName;
    }

    public String xAttributeNameTipText() {
        return "Attribute for x axis using regular expression used if set, otherwise the index is used";
    }

    public void setYAttributeName(BaseRegExp val) {
        this.m_YAttributeName = val;
        this.reset();
    }

    public BaseRegExp getYAttributeName() {
        return this.m_YAttributeName;
    }

    public String yAttributeNameTipText() {
        return "Attribute for y axis using regular expression used if set,otherwise the index is used";
    }

    public void setColorAttributeName(BaseRegExp val) {
        this.m_ColorAttributeName = val;
        this.reset();
    }

    public BaseRegExp getColorAttributeName() {
        return this.m_ColorAttributeName;
    }

    public String colorAttributeNameTipText() {
        return "Attribute for the colors using regular expression used if set,otherwise the index is used";
    }

    public void setXAttribute(String val) {
        this.m_XAttribute = val;
        this.reset();
    }

    public String getXAttribute() {
        return this.m_XAttribute;
    }

    public String xAttributeTipText() {
        return "Index of attribute to display on x axis, used onlyif regular expression not set";
    }

    public void setYAttribute(String val) {
        this.m_YAttribute = val;
        this.reset();
    }

    public String getYAttribute() {
        return this.m_YAttribute;
    }

    public String yAttributeTipText() {
        return "index of attribute to display on y axis, used only ifregular expression not set";
    }

    public void setColorAttribute(String val) {
        this.m_ColorAttribute = val;
        this.reset();
    }

    public String getColorAttribute() {
        return this.m_ColorAttribute;
    }

    public String colorAttributeTipText() {
        return "index of optional attribute to use for coloring, used only ifregular expression not set, ignored if empty";
    }

    public void setMouseClickAction(MouseClickAction value) {
        this.m_MouseClickAction = value;
        this.reset();
    }

    public MouseClickAction getMouseClickAction() {
        return this.m_MouseClickAction;
    }

    public String mouseClickActionTipText() {
        return "How to process mouse clicks in the plot.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public void clearPanel() {
        if (this.m_ScatterPlot != null) {
            DefaultSpreadSheet temp = new DefaultSpreadSheet();
            this.m_ScatterPlot.setData((SpreadSheet)temp);
        }
    }

    protected BasePanel newPanel() {
        this.m_ScatterPlot = new ScatterPlot();
        return this.m_ScatterPlot;
    }

    protected void display(Token token) {
        this.m_ScatterPlot.setXRegExp(this.m_XAttributeName);
        this.m_ScatterPlot.setXIndex(new Index(this.m_XAttribute));
        this.m_ScatterPlot.setYRegExp(this.m_YAttributeName);
        this.m_ScatterPlot.setColorRegExp(this.m_ColorAttributeName);
        this.m_ScatterPlot.setYIndex(new Index(this.m_YAttribute));
        this.m_ScatterPlot.setColorIndex(new Index(this.m_ColorAttribute));
        this.m_ScatterPlot.setData((SpreadSheet)token.getPayload());
        this.m_ScatterPlot.setOverlays(this.m_Overlays);
        this.m_ScatterPlot.setPaintlet(this.m_Paintlet);
        this.m_ScatterPlot.setMouseClickAction((MouseClickAction)OptionUtils.shallowCopy((Object)this.m_MouseClickAction));
        this.m_ScatterPlot.reset();
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractTextAndComponentDisplayPanel result = new AbstractTextAndComponentDisplayPanel("ScatterDisplay"){
            private static final long serialVersionUID = 4360182045245637304L;
            protected ScatterPlot m_ScatterPlot;

            protected void initGUI() {
                super.initGUI();
                this.m_ScatterPlot = new ScatterPlot();
                this.add((Component)((Object)this.m_ScatterPlot), "Center");
            }

            public void display(Token token) {
                this.m_ScatterPlot.setXRegExp(ScatterDisplay.this.m_XAttributeName);
                this.m_ScatterPlot.setXIndex(new Index(ScatterDisplay.this.m_XAttribute));
                this.m_ScatterPlot.setYRegExp(ScatterDisplay.this.m_YAttributeName);
                this.m_ScatterPlot.setColorRegExp(ScatterDisplay.this.m_ColorAttributeName);
                this.m_ScatterPlot.setYIndex(new Index(ScatterDisplay.this.m_YAttribute));
                this.m_ScatterPlot.setColorIndex(new Index(ScatterDisplay.this.m_ColorAttribute));
                this.m_ScatterPlot.setData((SpreadSheet)token.getPayload());
                this.m_ScatterPlot.setOverlays((AbstractScatterPlotOverlay[])OptionUtils.shallowCopy((Object[])ScatterDisplay.this.m_Overlays));
                this.m_ScatterPlot.setPaintlet((AbstractScatterPlotPaintlet)((Object)OptionUtils.shallowCopy((Object)((Object)ScatterDisplay.this.m_Paintlet))));
                this.m_ScatterPlot.setMouseClickAction((MouseClickAction)OptionUtils.shallowCopy((Object)ScatterDisplay.this.m_MouseClickAction));
                this.m_ScatterPlot.reset();
            }

            public void clearPanel() {
                DefaultSpreadSheet temp = new DefaultSpreadSheet();
                this.m_ScatterPlot.setData((SpreadSheet)temp);
            }

            public JComponent supplyComponent() {
                return this.m_ScatterPlot;
            }

            public String getCustomSupplyTextMenuItemCaption() {
                return ((ScatterPlot)ScatterDisplay.this.m_Panel).getCustomSupplyTextMenuItemCaption();
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return ((ScatterPlot)ScatterDisplay.this.m_Panel).getCustomTextFileFilter();
            }

            public String supplyText() {
                return ((ScatterPlot)ScatterDisplay.this.m_Panel).supplyText();
            }

            public void cleanUp() {
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    public SpreadSheet toSpreadSheet() {
        if (this.m_Panel == null) {
            return null;
        }
        return ((ScatterPlot)this.m_Panel).toSpreadSheet();
    }

    public String getCustomSupplyTextMenuItemCaption() {
        if (this.m_Panel == null) {
            return "Save plot as...";
        }
        return ((ScatterPlot)this.m_Panel).getCustomSupplyTextMenuItemCaption();
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        if (this.m_Panel == null) {
            return new ExtensionFileFilter("CSV files", "csv");
        }
        return ((ScatterPlot)this.m_Panel).getCustomTextFileFilter();
    }

    public String supplyText() {
        if (this.m_Panel == null) {
            return null;
        }
        return ((ScatterPlot)this.m_Panel).supplyText();
    }
}

