/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.boxplot;

import adams.core.Range;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.StatUtils;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseListWithButtons;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.ParameterPanel;
import adams.gui.event.PaintEvent;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.boxplot.BoxPlotGraph;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;

public class BoxPlotManager
extends BasePanel
implements PaintListener {
    private static final long serialVersionUID = -7912792208597490973L;
    protected BaseSplitPane m_SplitPane;
    protected DefaultListModel<String> m_ModelAvailableAttributes;
    protected DefaultListModel<String> m_ModelChosenAttributes;
    protected JPanel m_PanelRight;
    protected SpreadSheet m_Data;
    protected int m_WidthLeft;
    protected int m_Width;
    protected int m_Height;
    protected int m_AxisWidth;
    protected int m_NumHorizontal;
    protected boolean m_AxisSame;
    protected Color m_Color;
    protected boolean m_Fill;
    protected JSpinner m_SpinnerWidth;
    protected JSpinner m_SpinnerHeight;
    protected JSpinner m_SpinnerAxisWid;
    protected BaseCheckBox m_CheckBoxSameAxis;
    protected Range m_Range;
    protected BaseButton m_ButtonAdd;
    protected BaseButton m_ButtonAddAll;
    protected BaseListWithButtons m_ListAvailableAttributes;
    protected BaseListWithButtons m_ListChosenAttributes;
    protected BaseButton m_ButtonRemove;
    protected BaseButton m_ButtonRemoveAll;
    protected ParameterPanel m_PanelParams;
    protected JSpinner m_SpinnerGrid;
    protected BaseCheckBox m_CheckBoxFill;
    protected BaseButton m_ButtonFillColor;

    protected void initialize() {
        super.initialize();
        this.m_Width = 200;
        this.m_Height = 200;
        this.m_AxisWidth = 60;
        this.m_NumHorizontal = 3;
        this.m_ModelAvailableAttributes = new DefaultListModel();
        this.m_ModelChosenAttributes = new DefaultListModel();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_PanelRight = new JPanel(new BorderLayout());
        this.m_SplitPane.setRightComponent((Component)this.m_PanelRight);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_SplitPane.setResizeWeight(0.3);
        this.m_SplitPane.setOneTouchExpandable(true);
        JPanel panelLeft = new JPanel(new BorderLayout());
        this.m_SplitPane.setLeftComponent((Component)panelLeft);
        JPanel top = new JPanel(new BorderLayout());
        this.m_ListAvailableAttributes = new BaseListWithButtons();
        this.m_ListAvailableAttributes.setPreferredSize(new Dimension(this.m_WidthLeft, 140));
        this.m_ListAvailableAttributes.setModel(this.m_ModelAvailableAttributes);
        top.add((Component)this.m_ListAvailableAttributes, "North");
        this.m_ButtonAdd = new BaseButton("Add");
        this.m_ButtonAdd.setMnemonic('A');
        this.m_ButtonAdd.setEnabled(false);
        this.m_ButtonAdd.addActionListener(e -> this.addClicked());
        this.m_ButtonAddAll = new BaseButton("Add all");
        this.m_ButtonAddAll.setMnemonic('d');
        this.m_ButtonAddAll.addActionListener(e -> this.addAllClicked());
        this.m_ListAvailableAttributes.setBorder((Border)BorderFactory.createTitledBorder("Attributes"));
        this.m_ListAvailableAttributes.addListSelectionListener(e -> this.updateButtons());
        this.m_ListAvailableAttributes.addToButtonsPanel((Component)this.m_ButtonAdd);
        this.m_ListAvailableAttributes.addToButtonsPanel((Component)this.m_ButtonAddAll);
        JPanel bottom = new JPanel(new BorderLayout());
        this.m_ListChosenAttributes = new BaseListWithButtons();
        this.m_ListChosenAttributes.setPreferredSize(new Dimension(this.m_WidthLeft, 140));
        this.m_ListChosenAttributes.setModel(this.m_ModelChosenAttributes);
        bottom.add((Component)this.m_ListChosenAttributes, "Center");
        this.m_ButtonRemove = new BaseButton("Remove");
        this.m_ButtonRemove.setMnemonic('R');
        this.m_ButtonRemove.setEnabled(false);
        this.m_ButtonRemove.addActionListener(e -> this.removeClicked());
        this.m_ButtonRemoveAll = new BaseButton("Remove all");
        this.m_ButtonRemoveAll.setMnemonic('m');
        this.m_ButtonRemoveAll.setEnabled(false);
        this.m_ButtonRemoveAll.addActionListener(e -> this.removeAllClicked());
        this.m_ListChosenAttributes.setBorder((Border)BorderFactory.createTitledBorder("Chosen attributes"));
        this.m_ListChosenAttributes.addListSelectionListener(e -> this.updateButtons());
        this.m_ListChosenAttributes.addToButtonsPanel((Component)this.m_ButtonRemoveAll);
        this.m_ListChosenAttributes.addToButtonsPanel((Component)this.m_ButtonRemove);
        this.m_PanelParams = new ParameterPanel();
        JPanel centre = new JPanel(new BorderLayout());
        SpinnerNumberModel spinHeight = new SpinnerNumberModel(this.m_Height, 50, 500, 2);
        SpinnerNumberModel spinWidth = new SpinnerNumberModel(this.m_Width, 50, 500, 2);
        SpinnerNumberModel spinAxis = new SpinnerNumberModel(this.m_AxisWidth, 20, 300, 2);
        SpinnerNumberModel spinGrid = new SpinnerNumberModel((Number)this.m_NumHorizontal, Integer.valueOf(-1), null, (Number)1);
        this.m_SpinnerWidth = new JSpinner(spinWidth);
        this.m_SpinnerHeight = new JSpinner(spinHeight);
        this.m_SpinnerAxisWid = new JSpinner(spinAxis);
        this.m_SpinnerGrid = new JSpinner(spinGrid);
        this.m_SpinnerWidth.addChangeListener(e -> this.spinWidthChange(e));
        this.m_SpinnerHeight.addChangeListener(e -> this.spinHeightChange(e));
        this.m_SpinnerAxisWid.addChangeListener(e -> this.spinAxisChange(e));
        this.m_SpinnerGrid.addChangeListener(e -> this.spinHorizontalChange(e));
        this.m_CheckBoxSameAxis = new BaseCheckBox();
        this.m_CheckBoxSameAxis.addItemListener(e -> this.sameAxisChange(e));
        this.m_CheckBoxFill = new BaseCheckBox();
        this.m_CheckBoxFill.addItemListener(e -> this.fillChange(e));
        this.m_ButtonFillColor = new BaseButton("Choose");
        this.m_ButtonFillColor.addActionListener(e -> this.colorChange());
        this.m_PanelParams.addParameter("Width of plot", (Component)this.m_SpinnerWidth);
        this.m_PanelParams.addParameter("Height of plot", (Component)this.m_SpinnerHeight);
        this.m_PanelParams.addParameter("Width of axis", (Component)this.m_SpinnerAxisWid);
        this.m_PanelParams.addParameter("Number in each row", (Component)this.m_SpinnerGrid);
        this.m_PanelParams.addParameter("Use same axis", (Component)this.m_CheckBoxSameAxis);
        this.m_PanelParams.addParameter("Fill box", (Component)this.m_CheckBoxFill);
        this.m_PanelParams.addParameter("Fill color", (Component)this.m_ButtonFillColor);
        centre.add((Component)this.m_PanelParams, "Center");
        panelLeft.add((Component)top, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panelLeft.add((Component)panel2, "Center");
        panel2.add((Component)centre, "North");
        JPanel panel3 = new JPanel(new BorderLayout());
        panel2.add((Component)panel3, "Center");
        panel3.add((Component)bottom, "North");
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    public void setData(SpreadSheet inst) {
        this.m_Data = inst;
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonAdd.setEnabled(this.m_ListAvailableAttributes.getSelectedIndex() != -1);
        this.m_ButtonAddAll.setEnabled(this.m_ModelAvailableAttributes.size() != 0);
        this.m_ButtonRemove.setEnabled(this.m_ListChosenAttributes.getSelectedIndex() != -1);
        this.m_ButtonRemoveAll.setEnabled(this.m_ModelChosenAttributes.size() != 0);
    }

    protected void fillChange(ItemEvent val) {
        this.m_Fill = ((BaseCheckBox)val.getSource()).isSelected();
        this.update();
    }

    protected void colorChange() {
        Color newCol = JColorChooser.showDialog((Component)((Object)this), "Choose box color", this.m_Color);
        if (newCol != null) {
            this.m_Color = newCol;
        }
        this.update();
    }

    protected void updateGui() {
        this.m_CheckBoxSameAxis.setSelected(this.m_AxisSame);
        this.m_SpinnerAxisWid.setValue(this.m_AxisWidth);
        this.m_SpinnerHeight.setValue(this.m_Height);
        this.m_SpinnerGrid.setValue(this.m_NumHorizontal);
        this.m_SpinnerWidth.setValue(this.m_Width);
        this.m_CheckBoxFill.setSelected(this.m_Fill);
        if (this.m_Data != null) {
            this.update();
        }
        this.updateButtons();
    }

    public void reset() {
        this.m_ModelChosenAttributes.removeAllElements();
        this.updateGui();
        for (int g = 0; g < this.m_Data.getColumnCount(); ++g) {
            this.m_ModelAvailableAttributes.addElement(this.m_Data.getColumnName(g));
        }
        if (this.m_Range != null) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            this.m_Range.setMax(this.m_Data.getColumnCount());
            for (int t = 0; t < this.m_Data.getRowCount(); ++t) {
                if (!this.m_Range.isInRange(t)) continue;
                indices.add(t);
            }
            ArrayList<String> chosen = new ArrayList<String>();
            Iterator iterator = indices.iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                chosen.add(this.m_ModelAvailableAttributes.get(t));
            }
            for (String s : chosen) {
                this.m_ModelChosenAttributes.addElement(s);
                this.m_ModelAvailableAttributes.removeElement(s);
            }
        }
        this.update();
        this.updateButtons();
    }

    protected void addClicked() {
        if (this.m_ListAvailableAttributes.getSelectedIndex() == -1) {
            return;
        }
        int[] indices = this.m_ListAvailableAttributes.getSelectedIndices();
        Arrays.sort(indices);
        for (int index : indices) {
            this.m_ModelChosenAttributes.addElement((String)this.m_ListAvailableAttributes.getModel().getElementAt(index));
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_ModelAvailableAttributes.remove(indices[i]);
        }
        this.updateButtons();
        this.update();
    }

    protected void removeClicked() {
        if (this.m_ListChosenAttributes.getSelectedIndex() == -1) {
            return;
        }
        int[] indices = this.m_ListChosenAttributes.getSelectedIndices();
        Arrays.sort(indices);
        for (int index : indices) {
            this.m_ModelAvailableAttributes.addElement((String)this.m_ListChosenAttributes.getModel().getElementAt(index));
        }
        for (int i = indices.length - 1; i >= 0; --i) {
            this.m_ModelChosenAttributes.remove(indices[i]);
        }
        this.updateButtons();
        this.update();
    }

    protected void removeAllClicked() {
        this.m_ModelAvailableAttributes.removeAllElements();
        this.m_ModelChosenAttributes.removeAllElements();
        for (int g = 0; g < this.m_Data.getColumnCount(); ++g) {
            this.m_ModelAvailableAttributes.addElement(this.m_Data.getColumnName(g));
        }
        this.updateButtons();
        this.update();
    }

    protected void addAllClicked() {
        this.m_ModelAvailableAttributes.removeAllElements();
        this.m_ModelChosenAttributes.removeAllElements();
        for (int g = 0; g < this.m_Data.getColumnCount(); ++g) {
            this.m_ModelChosenAttributes.addElement(this.m_Data.getColumnName(g));
        }
        this.updateButtons();
        this.update();
    }

    protected void spinWidthChange(ChangeEvent e) {
        JSpinner spin = (JSpinner)e.getSource();
        this.m_Width = (Integer)spin.getModel().getValue();
        if (this.m_Data != null) {
            this.update();
        }
    }

    protected void spinHeightChange(ChangeEvent e) {
        JSpinner spin = (JSpinner)e.getSource();
        this.m_Height = (Integer)spin.getModel().getValue();
        if (this.m_Data != null) {
            this.update();
        }
    }

    protected void spinAxisChange(ChangeEvent e) {
        JSpinner spin = (JSpinner)e.getSource();
        this.m_AxisWidth = (Integer)spin.getModel().getValue();
        if (this.m_Data != null) {
            this.update();
        }
    }

    protected void spinHorizontalChange(ChangeEvent e) {
        JSpinner spin = (JSpinner)e.getSource();
        this.m_NumHorizontal = (Integer)spin.getModel().getValue();
        if (this.m_Data != null) {
            this.update();
        }
    }

    protected void sameAxisChange(ItemEvent e) {
        boolean bl = this.m_AxisSame = e.getStateChange() == 1;
        if (this.m_Data != null) {
            this.update();
        }
    }

    public void setBoxWidth(int val) {
        this.m_Width = val;
    }

    public int getBoxWidth() {
        return this.m_Width;
    }

    public void setBoxHeight(int val) {
        this.m_Height = val;
    }

    public int getBoxHeight() {
        return this.m_Height;
    }

    public void setAxisWidth(int val) {
        this.m_AxisWidth = val;
    }

    public int getAxisWidth() {
        return this.m_AxisWidth;
    }

    public void setNumHorizontal(int val) {
        this.m_NumHorizontal = val;
    }

    public int getNumHorizontal() {
        return this.m_NumHorizontal;
    }

    public void setSameAxis(boolean val) {
        this.m_AxisSame = val;
    }

    public boolean getSameAxis() {
        return this.m_AxisSame;
    }

    public void setRange(Range val) {
        this.m_Range = val;
    }

    public Range getRange() {
        return this.m_Range;
    }

    public void setFill(boolean val) {
        this.m_Fill = val;
    }

    public boolean getFill() {
        return this.m_Fill;
    }

    public void setColor(Color val) {
        this.m_Color = val;
    }

    public Color getColor() {
        return this.m_Color;
    }

    protected void update() {
        int numGraphs = this.m_ModelChosenAttributes.size();
        if (numGraphs != 0) {
            JPanel grid = this.m_NumHorizontal == 0 || this.m_NumHorizontal == -1 ? new JPanel(new GridLayout(1, 0)) : new JPanel(new GridLayout(0, this.m_NumHorizontal));
            this.m_PanelRight.removeAll();
            BaseScrollPane scrollPane = new BaseScrollPane((Component)grid);
            Dimension dim = new Dimension(this.m_Width, this.m_Height);
            Double max = null;
            Double min = null;
            if (this.m_AxisSame) {
                for (int i = 0; i < this.m_Data.getColumnCount(); ++i) {
                    boolean contains = false;
                    for (int j = 0; j < this.m_ModelChosenAttributes.size(); ++j) {
                        String inst;
                        String chosen = this.m_ModelChosenAttributes.get(j);
                        if (!chosen.equals(inst = this.m_Data.getColumnName(i))) continue;
                        contains = true;
                        break;
                    }
                    if (!contains) continue;
                    double[] data = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)i);
                    double tempMax = StatUtils.max((double[])data);
                    double tempMin = StatUtils.min((double[])data);
                    if (max == null) {
                        max = tempMax;
                    }
                    if (min == null) {
                        min = tempMin;
                    }
                    if (tempMax > max) {
                        max = tempMax;
                    }
                    if (!(tempMin < min)) continue;
                    min = tempMin;
                }
            }
            JPanel scrollHold = new JPanel();
            scrollHold.add((Component)scrollPane);
            BaseScrollPane holdScroll = new BaseScrollPane((Component)scrollHold);
            this.m_PanelRight.add((Component)holdScroll, "Center");
            for (int r = 0; r < this.m_ModelChosenAttributes.size(); ++r) {
                String toPlot = this.m_ModelChosenAttributes.getElementAt(r);
                BoxPlotGraph graph = new BoxPlotGraph();
                graph.pass(this.m_Data, toPlot);
                graph.setPreferredSize(dim);
                if (this.m_AxisSame) {
                    graph.axisSame(max, min);
                }
                graph.setColor(this.m_Color);
                graph.setFill(this.m_Fill);
                graph.setAxisWidth(Axis.LEFT, this.m_AxisWidth);
                graph.addPaintListener(this);
                JPanel graphPanel = new JPanel(new BorderLayout());
                JLabel title = new JLabel(toPlot, null, 0);
                graphPanel.add((Component)title, "North");
                graphPanel.add((Component)((Object)graph), "Center");
                graphPanel.setBorder(BorderFactory.createLineBorder(Color.black));
                grid.add(graphPanel);
            }
        } else {
            this.m_PanelRight.removeAll();
        }
        this.repaint();
        this.revalidate();
    }

    public void painted(PaintEvent e) {
        Graphics g = e.getGraphics();
        BoxPlotGraph graph = (BoxPlotGraph)((Object)e.getSource());
        if (e.getPaintMoment() == PaintEvent.PaintMoment.PAINT) {
            graph.paintPlot(g);
        }
    }
}

