/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.histogram;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import adams.data.statistics.StatUtils;
import adams.flow.sink.TextSupplier;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.PaintablePanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.histogram.HistogramOptions;
import adams.gui.visualization.stats.histogram.HistogramPanel;
import adams.gui.visualization.stats.paintlet.HistogramPaintlet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class Histogram
extends PaintablePanel
implements PopupMenuCustomizer,
TextSupplier,
SpreadSheetSupporter {
    private static final long serialVersionUID = -4366437103496819542L;
    protected SpreadSheet m_Data;
    protected Double[] m_Array;
    protected HistogramPanel m_Plot;
    protected HistogramPaintlet m_Val;
    protected HistogramOptions m_HistOptions;
    protected int m_Index;
    protected String m_DataName;
    protected double[][] m_Plotdata;
    protected String[] m_Ranges;
    protected double m_BinWidth;
    protected String m_Name;
    protected SpreadSheetFileChooser m_FileChooser;

    protected void initialize() {
        super.initialize();
        this.m_HistOptions = new HistogramOptions();
        this.m_Data = null;
        this.m_Array = null;
        this.m_DataName = "";
        this.m_Index = 0;
        this.m_Plotdata = new double[0][2];
        this.m_Ranges = new String[0];
        this.m_FileChooser = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Plot = new HistogramPanel();
        this.m_Plot.addPaintListener((PaintListener)this);
        this.m_Plot.setPopupMenuCustomizer(this);
        this.add((Component)((Object)this.m_Plot), "Center");
        this.m_Val = new HistogramPaintlet();
        this.m_Val.setPanel(this);
    }

    public void setOptions(HistogramOptions val) {
        this.m_HistOptions = val;
        this.m_HistOptions.getAxisX().configure((PlotPanel)this.m_Plot, Axis.BOTTOM);
        this.m_HistOptions.getAxisY().configure((PlotPanel)this.m_Plot, Axis.LEFT);
        this.removePaintlet((Paintlet)this.m_Val);
        this.m_Val = (HistogramPaintlet)this.m_HistOptions.getPaintlet().shallowCopy(true);
        this.m_Val.setPanel(this);
    }

    public HistogramOptions getOptions() {
        return this.m_HistOptions;
    }

    public void setData(SpreadSheet value) {
        this.m_Data = value;
        this.m_Array = null;
        this.update();
    }

    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void setArray(Double[] value) {
        this.m_Array = value;
        this.m_Data = null;
        this.update();
    }

    public Double[] getArray() {
        return this.m_Array;
    }

    public void setDataName(String value) {
        this.m_DataName = value;
    }

    public String getDataName() {
        return this.m_DataName;
    }

    public PlotPanel getPlot() {
        return this.m_Plot;
    }

    public void prepareUpdate() {
        Number[] numData;
        ArrayHistogram aHist = new ArrayHistogram();
        if (this.m_Data != null) {
            numData = StatUtils.toNumberArray((double[])SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_Index));
            this.m_Name = this.m_Data.getColumnName(this.m_Index);
        } else {
            numData = this.m_Array;
            this.m_Name = this.m_HistOptions.getAxisY().getLabel().isEmpty() ? "Data" : this.m_HistOptions.getAxisX().getLabel();
        }
        if (this.m_DataName.length() > 0) {
            this.m_Name = this.m_DataName;
        }
        if (numData == null) {
            this.m_Plotdata = new double[0][2];
            this.m_Ranges = new String[0];
            return;
        }
        aHist.add((Serializable[])numData);
        aHist.setBinWidth(this.m_HistOptions.m_WidthBin);
        aHist.setNumBins(this.m_HistOptions.m_NumBins);
        ArrayHistogram.BinCalculation bc = this.m_HistOptions.m_BoxType == HistogramOptions.BoxType.DENSITY ? ArrayHistogram.BinCalculation.DENSITY : ArrayHistogram.BinCalculation.MANUAL;
        aHist.setBinCalculation(bc);
        aHist.setDisplayRanges(true);
        AbstractArrayStatistic.StatisticContainer cont = aHist.calculate();
        int numBins = (Integer)cont.getMetaData("num-bins");
        double[] binX = (double[])cont.getMetaData("bin-x");
        this.m_BinWidth = (Double)cont.getMetaData("bin-width");
        this.m_Plotdata = new double[numBins][2];
        this.m_Ranges = new String[numBins];
        for (int i = 0; i < this.m_Plotdata.length; ++i) {
            this.m_Plotdata[i][1] = (Double)cont.getCell(0, i);
            this.m_Plotdata[i][0] = binX[i];
            this.m_Ranges[i] = cont.getHeader(i);
        }
        AxisPanel axisBottom = this.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.getPlot().getAxis(Axis.LEFT);
        axisBottom.setMinimum(this.m_Plotdata[0][0]);
        axisBottom.setMaximum(this.m_Plotdata[this.m_Plotdata.length - 1][0] + this.m_BinWidth);
        axisBottom.setAxisName(this.m_Name);
        axisLeft.setMinimum(0.0);
        double max = this.m_Plotdata[1][1];
        for (int i = 1; i < this.m_Plotdata.length; ++i) {
            if (!(this.m_Plotdata[i][1] > max)) continue;
            max = this.m_Plotdata[i][1];
        }
        axisLeft.setMaximum(max);
        if (this.m_HistOptions.getAxisY().getLabel().isEmpty()) {
            axisLeft.setAxisName("Frequency");
        } else {
            axisLeft.setAxisName(this.m_HistOptions.getAxisY().getLabel());
        }
    }

    protected boolean canPaint(Graphics g) {
        return this.m_Plot != null;
    }

    public void setIndex(int val) {
        this.m_Index = val;
        this.update();
    }

    public int getIndex() {
        return this.m_Index;
    }

    public double[][] getPlotdata() {
        return this.m_Plotdata;
    }

    public String[] getRanges() {
        return this.m_Ranges;
    }

    public double getBinWidth() {
        return this.m_BinWidth;
    }

    protected void save() {
        int retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this))) != 0) {
            return;
        }
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_FileChooser.getWriter();
        if (!writer.write(this.toSpreadSheet(), this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to save data to file:\n" + this.m_FileChooser.getSelectedFile()));
        }
    }

    protected void showData() {
        SpreadSheetDialog dialog = this.getParentDialog() != null ? new SpreadSheetDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new SpreadSheetDialog(this.getParentFrame(), false);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Histogram" + (this.m_DataName.isEmpty() ? "" : " - " + this.m_DataName));
        dialog.setSpreadSheet(this.toSpreadSheet());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        menu.addSeparator();
        JMenuItem menuitem = new JMenuItem("Save data...", GUIHelper.getIcon((String)"save.gif"));
        menuitem.addActionListener(ae -> this.save());
        menu.add(menuitem);
        menuitem = new JMenuItem("Show data...", GUIHelper.getIcon((String)"spreadsheet.png"));
        menuitem.addActionListener(ae -> this.showData());
        menu.add(menuitem);
    }

    public SpreadSheet toSpreadSheet() {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("B").setContentAsString(this.getPlot().getAxis(Axis.LEFT).getAxisName());
        row.addCell("R").setContentAsString("Range");
        row.addCell("V").setContentAsString(this.getPlot().getAxis(Axis.BOTTOM).getAxisName());
        for (int i = 0; i < this.m_Plotdata.length; ++i) {
            row = result.addRow();
            row.addCell("B").setContent(Double.valueOf(this.m_Plotdata[i][0]));
            row.addCell("R").setContentAsString(this.m_Ranges[i]);
            row.addCell("V").setContent(Double.valueOf(this.m_Plotdata[i][1]));
        }
        return result;
    }

    public String getCustomSupplyTextMenuItemCaption() {
        return "Save histogram as...";
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("CSV files", "csv");
    }

    public String supplyText() {
        return this.toSpreadSheet().toString();
    }
}

