/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.ColorProvider;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.stats.paintlet.AbstractColorPaintlet;
import adams.gui.visualization.stats.paintlet.AbstractScatterPlotHitDetector;
import java.awt.Color;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractScatterPlotPaintlet
extends AbstractColorPaintlet
implements AntiAliasingSupporter,
HitDetectorSupporter<AbstractScatterPlotHitDetector> {
    private static final long serialVersionUID = 7191423312364530577L;
    protected int m_XIndex;
    protected int m_YIndex;
    protected int m_ColorIndex;
    protected int m_Size;
    protected double[] m_XData;
    protected double[] m_YData;
    protected String[] m_ColorData;
    protected Map<String, Color> m_ColorMapping;
    protected ColorProvider m_ColorProvider;
    protected AxisPanel m_AxisLeft;
    protected AxisPanel m_AxisBottom;
    protected boolean m_AntiAliasingEnabled;
    protected AbstractScatterPlotHitDetector m_HitDetector;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
        this.m_OptionManager.add("color-provider", "colorProvider", (Object)new DefaultColorProvider());
    }

    protected void initialize() {
        super.initialize();
        this.m_XIndex = 0;
        this.m_YIndex = 0;
        this.m_ColorIndex = -1;
        this.m_HitDetector = this.newHitDetector();
    }

    protected void reset() {
        super.reset();
        this.m_XData = null;
        this.m_YData = null;
        this.m_ColorData = null;
        this.m_ColorMapping = null;
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    public void setColorProvider(ColorProvider value) {
        this.m_ColorProvider = value;
        this.memberChanged();
    }

    public ColorProvider getColorProvider() {
        return this.m_ColorProvider;
    }

    public String colorProviderTipText() {
        return "The color provider to use when using a column for the plot colors.";
    }

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    protected void doPerformPaint(Graphics g, PaintEvent.PaintMoment moment) {
        if (this.m_Data != null) {
            this.drawData(g);
        }
    }

    public String toString() {
        return OptionUtils.getCommandLine((Object)((Object)this));
    }

    protected Color getActualColor(int index, Color defColor) {
        if (this.m_ColorMapping == null) {
            return defColor;
        }
        return this.m_ColorMapping.get(this.m_ColorData[index]);
    }

    protected void drawData(Graphics g) {
        if (this.m_Data != null) {
            g.setColor(this.m_Color);
            GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
            if (this.m_XData == null) {
                this.m_XData = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_XIndex);
                this.m_YData = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_YIndex);
                if (this.m_ColorIndex > -1) {
                    this.m_ColorData = SpreadSheetUtils.getColumn((SpreadSheet)this.m_Data, (int)this.m_ColorIndex, (boolean)false, (boolean)false);
                    String[] unique = SpreadSheetUtils.getColumn((SpreadSheet)this.m_Data, (int)this.m_ColorIndex, (boolean)true, (boolean)true);
                    this.m_ColorMapping = new HashMap<String, Color>();
                    this.m_ColorProvider.resetColors();
                    for (String value : unique) {
                        this.m_ColorMapping.put(value, this.m_ColorProvider.next());
                    }
                }
            }
            this.m_AxisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            this.m_AxisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
        }
    }

    public int getXIndex() {
        return this.m_XIndex;
    }

    public void setXIndex(int val) {
        this.m_XIndex = val;
        this.memberChanged();
    }

    public int getYIndex() {
        return this.m_YIndex;
    }

    public void setYIndex(int val) {
        this.m_YIndex = val;
        this.memberChanged();
    }

    public int getColorIndex() {
        return this.m_ColorIndex;
    }

    public void setColorIndex(int val) {
        this.m_ColorIndex = val;
        this.memberChanged();
    }

    public AbstractScatterPlotHitDetector newHitDetector() {
        return null;
    }

    public AbstractScatterPlotHitDetector getHitDetector() {
        return this.m_HitDetector;
    }
}

