/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.gui.visualization.stats.paintlet.AbstractScatterPlotPaintlet;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ScatterPaintletErrors
extends AbstractScatterPlotPaintlet {
    private static final long serialVersionUID = -8859664992076524292L;

    public String globalInfo() {
        return "Paintlet that draws data on the scatter plot as crosses whose size depends on the error between x and y values. Mainly useful for plotting predicted vs actual.";
    }

    @Override
    protected void drawData(Graphics g) {
        super.drawData(g);
        if (this.m_XData == null || this.m_YData == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        for (int i = 0; i < this.m_XData.length; ++i) {
            int size = (int)(10.0 * (this.m_XData[i] - this.m_YData[i]) / this.m_XData[i]);
            if (size > 10) {
                size = 10;
            }
            if (size < 2) {
                size = 2;
            }
            int posX = this.m_AxisBottom.valueToPos(this.m_XData[i]);
            int posY = this.m_AxisLeft.valueToPos(this.m_YData[i]);
            g2d.setColor(this.getActualColor(i, this.m_Color));
            g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
            g2d.drawLine(posX - size, posY - size, posX + size, posY + size);
            g2d.drawLine(posX - size, posY + size, posX + size, posY - size);
        }
    }
}

