/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.paintlet;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.core.GUIHelper;
import adams.gui.event.PaintEvent;
import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.stats.paintlet.AbstractColorPaintlet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class VsFitPaintlet
extends AbstractColorPaintlet
implements AntiAliasingSupporter {
    private static final long serialVersionUID = 7346236357262878744L;
    protected int m_Index;
    protected int m_PredInd;
    protected boolean m_Fill;
    protected int m_Size;
    protected Color m_FillColor;
    protected boolean m_AntiAliasingEnabled;

    public PaintEvent.PaintMoment getPaintMoment() {
        return PaintEvent.PaintMoment.PAINT;
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("size", "size", (Object)5);
        this.m_OptionManager.add("fill-point", "fillPoint", (Object)true);
        this.m_OptionManager.add("fill-color", "fillColor", (Object)Color.RED);
        this.m_OptionManager.add("anti-aliasing-enabled", "antiAliasingEnabled", (Object)GUIHelper.getBoolean(((Object)((Object)this)).getClass(), (String)"antiAliasingEnabled", (Boolean)true));
    }

    public void setFillPoint(boolean val) {
        this.m_Fill = val;
        this.memberChanged();
    }

    public boolean getFillPoint() {
        return this.m_Fill;
    }

    public String fillPointTipText() {
        return "Whether to fill the data point with solid color";
    }

    public void setFillColor(Color val) {
        this.m_FillColor = val;
        this.memberChanged();
    }

    public Color getFillColor() {
        return this.m_FillColor;
    }

    public String fillColorTipText() {
        return "color for filling the data points";
    }

    public void setSize(int val) {
        this.m_Size = val;
        this.memberChanged();
    }

    public int getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "Size of the data points";
    }

    public void setAntiAliasingEnabled(boolean value) {
        this.m_AntiAliasingEnabled = value;
        this.memberChanged();
    }

    public boolean isAntiAliasingEnabled() {
        return this.m_AntiAliasingEnabled;
    }

    public String antiAliasingEnabledTipText() {
        return "If enabled, uses anti-aliasing for drawing lines.";
    }

    protected void doPerformPaint(Graphics g, PaintEvent.PaintMoment moment) {
        if (this.m_Data != null) {
            GUIHelper.configureAntiAliasing((Graphics)g, (boolean)this.m_AntiAliasingEnabled);
            AxisPanel axisBottom = this.getPanel().getPlot().getAxis(Axis.BOTTOM);
            AxisPanel axisLeft = this.getPanel().getPlot().getAxis(Axis.LEFT);
            double[] predicted = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_PredInd);
            double[] residuals = SpreadSheetUtils.getNumericColumn((SpreadSheet)this.m_Data, (int)this.m_Index);
            g.setColor(Color.BLACK);
            g.drawLine(0, axisLeft.valueToPos(0.0), axisBottom.getWidth(), axisLeft.valueToPos(0.0));
            for (int i = 0; i < residuals.length; ++i) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
                if (this.m_Fill) {
                    g2d.setColor(this.m_FillColor);
                    g2d.setStroke(new BasicStroke(0.0f));
                    g2d.fillOval(axisBottom.valueToPos(predicted[i]) - this.m_Size / 2, axisLeft.valueToPos(residuals[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
                }
                g2d.setStroke(new BasicStroke(this.m_StrokeThickness));
                g2d.setColor(this.m_Color);
                g2d.drawOval(axisBottom.valueToPos(predicted[i]) - this.m_Size / 2, axisLeft.valueToPos(residuals[i]) - this.m_Size / 2, this.m_Size, this.m_Size);
            }
        }
    }

    public String globalInfo() {
        return "Paints the data for the versus fit graph";
    }

    public void setIndices(int res, int pred) {
        this.m_Index = res;
        this.m_PredInd = pred;
    }
}

