/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.stats.boxplot.BoxPlotManager;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;

public class BoxPlot
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -8553869138965368551L;
    protected BoxPlotManager m_BoxPlot;
    protected boolean m_SameAxis;
    protected Range m_AttString;
    protected int m_WidthPlot;
    protected int m_HeightPlot;
    protected int m_WidthAx;
    protected int m_NumHorizontal;
    protected boolean m_Fill;
    protected Color m_Color;

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public boolean supportsClear() {
        return true;
    }

    public void clearPanel() {
        if (this.m_BoxPlot != null) {
            DefaultSpreadSheet temp = new DefaultSpreadSheet();
            this.m_BoxPlot.setData((SpreadSheet)temp);
            this.m_BoxPlot.reset();
        }
    }

    protected BasePanel newPanel() {
        this.m_BoxPlot = new BoxPlotManager();
        return this.m_BoxPlot;
    }

    protected void display(Token token) {
        this.m_BoxPlot.setBoxWidth(this.m_WidthPlot);
        this.m_BoxPlot.setBoxHeight(this.m_HeightPlot);
        this.m_BoxPlot.setAxisWidth(this.m_WidthAx);
        this.m_BoxPlot.setNumHorizontal(this.m_NumHorizontal);
        this.m_BoxPlot.setSameAxis(this.m_SameAxis);
        this.m_BoxPlot.setRange(this.m_AttString);
        this.m_BoxPlot.setData((SpreadSheet)token.getPayload());
        this.m_BoxPlot.setFill(this.m_Fill);
        this.m_BoxPlot.setColor(this.m_Color);
        this.m_BoxPlot.reset();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width-plot", "widthPlot", (Object)200, (Number)50, (Number)500);
        this.m_OptionManager.add("height-plot", "heightPlot", (Object)200, (Number)50, (Number)500);
        this.m_OptionManager.add("width-ax", "widthAx", (Object)50, (Number)20, (Number)100);
        this.m_OptionManager.add("num-horizontal", "numHorizontal", (Object)3, (Number)-1, null);
        this.m_OptionManager.add("fill-box", "fillBox", (Object)true);
        this.m_OptionManager.add("color", "color", (Object)Color.RED);
        this.m_OptionManager.add("same-axis", "sameAxis", (Object)false);
        this.m_OptionManager.add("attributes", "attributes", (Object)new Range("first-last"));
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"attributes", (Object)this.m_AttString.getRange(), (String)", atts: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"numHorizontal", (Object)this.m_NumHorizontal, (String)", #horizontal: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"sameAxis", (boolean)this.m_SameAxis, (String)"same axis", (String)", ");
        return result;
    }

    public void setFillBox(boolean val) {
        this.m_Fill = val;
        this.reset();
    }

    public boolean getFillBox() {
        return this.m_Fill;
    }

    public String fillBoxTipText() {
        return "Fill the box plots with color";
    }

    public void setColor(Color val) {
        this.m_Color = val;
        this.reset();
    }

    public Color getColor() {
        return this.m_Color;
    }

    public String colorTipText() {
        return "Color to fill box plots";
    }

    public void setWidthPlot(int val) {
        this.m_WidthPlot = val;
        this.reset();
    }

    public int getWidthPlot() {
        return this.m_WidthPlot;
    }

    public String widthPlotTipText() {
        return "Width of each box plot";
    }

    public void setHeightPlot(int val) {
        this.m_HeightPlot = val;
        this.reset();
    }

    public int getHeightPlot() {
        return this.m_HeightPlot;
    }

    public String heightPlotTipText() {
        return "Height of each box plot";
    }

    public void setWidthAx(int val) {
        this.m_WidthAx = val;
        this.reset();
    }

    public int getWidthAx() {
        return this.m_WidthAx;
    }

    public String widthAxTipText() {
        return "Width of box plot y axis";
    }

    public void setNumHorizontal(int val) {
        this.m_NumHorizontal = val;
        this.reset();
    }

    public int getNumHorizontal() {
        return this.m_NumHorizontal;
    }

    public String numHorizontalTipText() {
        return "Number of box plots to display on each row, -1 and 0 aredefault and will display all the box plots in one row";
    }

    public String globalInfo() {
        return "Actor for displaying box plots.\n\nFor more information, see:\nhttp://en.wikipedia.org/wiki/Box_plot";
    }

    protected int getDefaultWidth() {
        return 1000;
    }

    protected int getDefaultHeight() {
        return 700;
    }

    public void setAttributes(Range val) {
        this.m_AttString = val;
        this.reset();
    }

    public Range getAttributes() {
        return this.m_AttString;
    }

    public String attributesTipText() {
        return "Attributes to display in box plots.";
    }

    public void setSameAxis(boolean val) {
        this.m_SameAxis = val;
        this.reset();
    }

    public boolean getSameAxis() {
        return this.m_SameAxis;
    }

    public String sameAxisTipText() {
        return "Box plots have same axis";
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel("BoxPlot"){
            private static final long serialVersionUID = -5112946659280550587L;
            protected BoxPlotManager m_BoxPlot;

            protected void initGUI() {
                super.initGUI();
                this.m_BoxPlot = new BoxPlotManager();
                this.add((Component)((Object)this.m_BoxPlot), "Center");
            }

            public void display(Token token) {
                this.m_BoxPlot.setBoxWidth(BoxPlot.this.m_WidthPlot);
                this.m_BoxPlot.setBoxHeight(BoxPlot.this.m_HeightPlot);
                this.m_BoxPlot.setAxisWidth(BoxPlot.this.m_WidthAx);
                this.m_BoxPlot.setNumHorizontal(BoxPlot.this.m_NumHorizontal);
                this.m_BoxPlot.setSameAxis(BoxPlot.this.m_SameAxis);
                this.m_BoxPlot.setRange(BoxPlot.this.m_AttString);
                this.m_BoxPlot.setData((SpreadSheet)token.getPayload());
                this.m_BoxPlot.setFill(BoxPlot.this.m_Fill);
                this.m_BoxPlot.setColor(BoxPlot.this.m_Color);
                this.m_BoxPlot.reset();
            }

            public void clearPanel() {
                DefaultSpreadSheet temp = new DefaultSpreadSheet();
                this.m_BoxPlot.setData((SpreadSheet)temp);
                this.m_BoxPlot.reset();
            }

            public JComponent supplyComponent() {
                return this.m_BoxPlot;
            }

            public void cleanUp() {
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

